BEM.DOM.decl({ block: 'filter-conditions-tree', baseBlock: 'i-filter-conditions-group' }, {
    onSetMod: {
        js: function() {
            u.graspSelf.call(this, {
                _categoryChooser: 'b-feed-category-chooser inside',
                _priceRange: 'filter-condition-edit-control on price-range',
                _vendorInput: 'filter-condition-edit-control on vendor-input'
            });

            //mapping название отношения -> id фильтра
            this._modelIdMap = {};

            this.__base.apply(this, arguments);
            this._filterModel.get('conditionTree').forEach(function(model) {
                this._modelIdMap[model.get('field')] = model.id;
            }, this);
        }
    },

    /**
     * Возвращает список условий фильтра в виде массива
     * @returns {Array}
     * @private
     */
    _getConditionsList: function() {
        return u._.map(this._getConditionsHash(), function(cond) { return cond; })
    },

    /**
     * Возвращает хэш с данными по условиям из списка
     * @returns { { id: 'String', field: 'String', relation: 'String', value: * } }
     * @private
     */
    _getConditionsHash: function() {
        var hash = {},
            condition;

        this._filterModel.get('conditionTree').forEach(function(model) {
            condition = model.toJSON();
            //categoryId никогда не отфильтровываем, остальыне отфильтровываем если пустые
            if (condition.value.length || condition.field == 'categoryId') (hash[model.get('id')] = condition);
        });

        return hash;
    },

    _initCommonEvents: function() {
        var value;

        this._subscriptionManager
            .on(this._categoryChooser, 'change', function() {
                this._filterModel.get('conditionTree')
                    .getById(this._modelIdMap.categoryId)
                    .set('value', this._categoryChooser.getValue());
            }, this)
            .on(this._priceRange, 'change', function() {
                var value = this._priceRange.getData();

                value = value[0] && (value[0].min || value[0].max) ? value : [];

                this._filterModel.get('conditionTree').getById(this._modelIdMap.price).set('value', value);
            }, this)
            .on(this._vendorInput, 'change', function() {
                this._filterModel.get('conditionTree')
                    .getById(this._modelIdMap.vendor)
                    .set('value', this._vendorInput.getData());
            }, this);
    },

    /**
    * Валидирует список условий фильтра
    * @returns {Object}
    */
    validate: function() {
        var validateResult = { isValid: true },
            currentConditionValidateResult,
            totalValidateResult;

        //валидируем весь список условий
        totalValidateResult = u['i-filter-edit'].validateConditionsList(this._getConditionsList());

        validateResult.isValid = totalValidateResult.isValid;

        if (totalValidateResult.errors && totalValidateResult.errors.length) {
            validateResult.errors = validateResult.errors || {};
            validateResult.errors.total = totalValidateResult.errors
        }

        //валидируем каждое условие по отдельности
        u._.forEach(this._getConditionsHash(), function(condition, condId) {
            currentConditionValidateResult = u['i-filter-edit'].validateCondition(condition);
            validateResult.isValid = validateResult.isValid && currentConditionValidateResult.isValid;

            if (!currentConditionValidateResult.isValid) {
                validateResult.errors = validateResult.errors || {};

                validateResult.errors[condId] = currentConditionValidateResult.errors
            }
        }, this);

        this._errors = validateResult.errors || {};

        return validateResult;
    }
});
