block('footer')(

    def()(function() {

        return applyNext({
            agencyContacts: this.data.campaign_agency_contacts
        });
    }),

    content()(function() {
        var data = this.data,
            domains = u.consts('domains'),
            // @belyanskii - По задаче DIRECT-64949, убрать когда будет приходить тип агенства
            isSelfAgency = (data.login_rights || {}).agency_manager_email === 'agency-service@yandex-team.ru',
            retPathParams = data.csrf_token ? { csrf_token: data.csrf_token } : undefined;

        return [
            {
                elem: 'column',
                elemMods: {
                    side: 'left'
                },
                content: data.HTTP_METHOD != 'POST' && data.cmd != 'errorPage' ?
                    {
                        block: 'lang-switcher',
                        noMore: true,
                        retPath: this.ctx.retPath || encodeURIComponent(u.getCurrentUrl(retPathParams))
                    } :
                    '&nbsp;'
            },
            {
                elem: 'column',
                elemMods: {
                    side: 'center'
                },
                content: [
                    !this.agencyContacts && !domains.tr && {
                        elem: 'contact',
                        content: {
                            block: 'b-office-contacts',
                            mods: {
                                type: 'common'
                            }
                        }
                    },
                    !!this.agencyContacts && {
                        elem: 'contact',
                        content: {
                            block: 'b-agency-contacts',
                            mods: {
                                type: 'footer'
                            },
                            agencyContacts: this.agencyContacts
                        }
                    }
                ]
            },
            {
                elem: 'column',
                elemMods: {
                    side: 'right'
                },
                content: [
                    {
                        block: 'copyright',
                        mix: [{
                            block: 'footer',
                            elem: 'copyright'
                        }],
                        start: u.consts('domains').tr ? 2011 : 2001
                    },
                    {
                        elem: 'links',
                        content: [
                            !!data.client_features && !!data.client_features.touch_direct_enabled &&
                            !!data.uatraits.isMobile && !data.uatraits.isTablet && {
                                elem: 'link',
                                content:
                                    iget2('footer', 'move-to-touch-version', 'Перейти в мобильную версию')
                                ,
                                url: u.formatUrl({
                                    protocol: data.scheme,
                                    host: data.server_name,
                                    path: 'touch/on'
                                })
                            },
                            {
                                elem: 'link',
                                url: u.formatUrl({
                                    protocol: 'https',
                                    host: (/kz|by/.test(data.yandex_domain) ? 'yandex.ru' : data.yandex_domain),
                                    path: 'support/direct/troubleshooting/start.xml'
                                }),
                                content: isSelfAgency ?
                                    iget2('footer', 'otdel-po-rabote-s', 'Отдел по работе с рекламными агентствами') :
                                    this.agencyContacts ?
                                        iget2('footer', 'otdel-klientskogo-servisa-yandeksa', 'Отдел клиентского сервиса Яндекса') :
                                        iget2('footer', 'otdel-klientskogo-servisa', 'Отдел клиентского сервиса')
                            },
                            apply('links')
                        ]
                    }
                ]
            }
        ];
    }),

    mode('links')(''),

    match(function() {
        return !u.consts('domains').tr;
    }).mode('links')(function() {
        return [{
            elem: 'link',
            url: 'https://advertising.' + this.data.yandex_domain,
            content: iget2('footer', 'reklama', 'Реклама')
        }];
    })
);
