block('goals-selector')(

    def()(function() {
        return applyNext({
            'mods.disabled': this.mods.disabled || (this.ctx.goalsList.length ? '' : 'yes'),
            names: this.ctx.goalsList.reduce(function(result, goal) {
                return u._.set(result, goal.id, goal.name);
            }, {})
        });
    }),

    match(function() {
        return !(this.ctx.selectedIds || []).length;
    }).mix()(function() {
        return {
            mods: { 'initial-empty': 'yes' }
        };
    }),

    js()(function() {
        return {
            names: this.names,
            limit: this.ctx.limit
        };
    }),

    content()(function() {
        var ctx = this.ctx,
            goalsList = ctx.goalsList || [],
            selectedIds = ctx.selectedIds || [],
            names = this.names,
            goals = goalsList.reduce(
                function(result, item) {
                    var key = item.status !== 'active' ?
                        'idle' :
                        (item.isMeaningful ? 'meaningful' : 'active'),
                        isSelected = selectedIds.find(function(itemId) {
                            return item.id === '' + itemId;
                        });
                    result[key].push({
                        elem: 'item',
                        elemMods: isSelected ? { selected: 'yes' } : undefined,
                        name: item.id,
                        content: item.name,
                        js: { text: item.name, id: item.id }
                    });

                    return result;
                },
                {
                    meaningful: [],
                    active: [],
                    idle: []
                }
            ),
            isNeedGroups = goals.idle.length || goals.meaningful.length ||
                u._.reduce(goals, function(result, items) { return result += items.length ? 1 : 0 }, 0) > 1,
            labels = {
                meaningful: [
                    iget2('goals-selector', 'meaningful-goals', 'Ключевые цели'),
                    {
                        block: 'check-button',
                        mix: { block: 'goals-selector', elem: 'meaningful-common' },
                        mods: { size: 'xs', pseudo: 'yes', theme: 'normal' },
                        content: iget2('goals-selector', 'check-all', 'Выбрать все')
                    }
                ],
                active: iget2('goals-selector', 'active-goals', 'Активные'),
                idle: iget2('goals-selector', 'idle-goals', 'Удаленные')
            },
            getChooser = function(items) {
                var isWithSearch = items.length > 1;

                return {
                    block: 'b-chooser',
                    mix: { block: 'goals-selector', elem: 'chooser' },
                    mods: { multi: 'yes', theme: 'checkboxes', search: isWithSearch ? 'yes' : '' },
                    content: [
                        isWithSearch && {
                            elem: 'search',
                            mix: { block: 'goals-selector', elem: 'search' },
                        },
                        {
                            elem: 'wrap',
                            content: items
                        },
                        isWithSearch && {
                            elem: 'not-found',
                            mix: { block: 'goals-selector', elem: 'not-found' },
                        }
                    ]
                };
            };

        return [
            {
                block: 'button2',
                mods: { theme: 'normal', size: 's', width: 'max', disabled: this.mods.disabled },
                iconRight: {
                    mods: { type: 'arrow', direction: 'bottom' }
                },
                mix: { block: 'goals-selector', elem: 'button' },
                text: selectedIds.map(function(goalId) { return u.htmlDecode(names[goalId]) }).join(', ') || '—'
            },
            {
                block: 'popup2',
                mods: { target: 'anchor', theme: 'normal', autoclosable: 'yes' },
                directions: ['bottom-left', 'top-left'],
                mix: { block: 'goals-selector', elem: 'popup' },
                content: {
                    block: 'goals-selector',
                    elem: 'popup-content',
                    content: isNeedGroups ?
                        u._.map(goals, function(items, key) {
                            return items.length ?
                                [
                                    { block: 'goals-selector', elem: 'title', content: labels[key] },
                                    getChooser(items)
                                ] :
                                '';
                        }, []) :
                        getChooser(u._.reduce(goals, function(result, items) {
                            return result.concat(items)
                        }, []))
                }
            }
        ];
    })

);
