BEM.DOM.decl('goals-selector', {

    onSetMod: {

        js: function() {
            this._popup = this.findBlockOn('popup', 'popup2');
            this._button = this.findBlockOn('button', 'button2');
            this._choosers = this.findBlocksOn('chooser', 'b-chooser');
            this._meaningfulCommon = this.findBlockInside('meaningful-common', 'check-button');

            this._popup.setAnchor(this._button);

            this._subMan = BEM.create('i-subscription-manager');

            if (this._meaningfulCommon) {
                this._subMan.on(this._meaningfulCommon, 'click', this._onMeaningfulCommonClick, this);
            }

            this._subMan.on(this._popup, 'beforeOpen beforeClose', this._onPopupOpenClose, this);

            this._subMan.onFirst(this._popup, 'beforeOpen', function() {
                this._checkLimit();
            }, this);

            this._choosers.forEach(function(chooser) {
                this._subMan.on(chooser, 'change', this._onChoose, this);
            }, this);

            this._limit = this.params.limit;
        },

        disabled: {
            yes: function() {
                this._popup.delMod('visible');
                this._button.setMod('disabled', 'yes');
            },

            '': function() {
                // не снимаем `disabled` когда целей нет
                if (u._.size(this.params.names)) {
                    this._button.delMod('disabled');
                }
            }
        }

    },

    getVal: function() {
        return this.hasMod('disabled', 'yes') ?
            [] :
            this._choosers.reduce(function(result, chooser) {
                return result.concat(u._.map(chooser.getSelected(), 'name'))
            }, []);
    },

    uncheckAll: function() {
        this._choosers.forEach(function(chooser) {
            chooser.uncheckAll();
        });
    },

    updateLimit: function(limit) {
        this._limit = limit;

        this._checkLimit();
    },

    _checkLimit: function(value) {
        value || (value = this.getVal());

        var isLimitReached = value.length >= this._limit;

        if (isLimitReached) {
            this._choosers.forEach(function(chooser) {
                var namesToDisable = u._.map(u._.filter(chooser.getAll(), { selected: false }), 'name');

                namesToDisable.forEach(function(name) {
                    chooser.disable(name);
                });
            });
        } else {
            this._choosers.forEach(function(chooser) {
                var namesToEnable = u._.map(chooser.getAll('disabled'), 'name');

                namesToEnable.forEach(function(name) {
                    chooser.enable(name);
                });
            });
        }

        if (this._meaningfulCommon) {
            var chooser = this._choosers[0],
                meaningfulCount = chooser.getAll().length,
                selectedMeaningfulCount = chooser.getAll('selected').length,
                isAllChoosed = meaningfulCount === selectedMeaningfulCount;

            this._meaningfulCommon
                .setMod('checked', isAllChoosed || isLimitReached && meaningfulCount ? 'yes' : '')
                .setMod('disabled', isLimitReached && !selectedMeaningfulCount ? 'yes' : '');
        }
    },

    /**
     * Обработчик клика по кнопке
     * @private
     */
    _onButtonClick: function() {
        this._popup.toggleMod('visible', 'yes');
    },

    /**
     * Крутит стрелку вокгруг своей оси
     * @private
     */
    _rotateArrow: function() {
        this._button.blockInside('icon').toggleMod('direction', 'top', 'bottom');
    },

    /**
     * Обработчик событий открытия и закрытия попапа
     * @param {jQuery.Event} e
     * @private
     */
    _onPopupOpenClose: function(e) {
        if (e.type === 'beforeOpen') {
            this._setMaxHeight();
        }

        this._rotateArrow();
    },

    /**
     * Обработчик изменений в блоке
     * @private
     */
    _onChange: function() {
        var value = this.getVal();

        this._updateButtonText(value);
        this._checkLimit(value);

        this.trigger('change', { value: value });
    },

    /**
     * Обработчик выбора в `b-chooser`
     * @param {jQuery.Event} e
     * @param {object} data
     * @param {string} data.name
     * @param {boolean} data.selected
     * @private
     */
    _onChoose: function(e, data) {
        if (!data.silent) {
            this._onChange();
        }
    },

    _updateButtonText: function(value) {
        var names = this.params.names;

        this._button.setText(
            value.map(function(goalId) { return u.htmlDecode(names[goalId]) }).join(', ') || '—'
        );
    },

    _onMeaningfulCommonClick: function(e, data) {
        var meaningfulChooser = this._choosers[0],
            isChecked = e.block.isChecked();

        if (isChecked) {
            u._.map(u._.filter(meaningfulChooser.getAll(), { selected: false }), 'name')
                .slice(0, this._limit - this.getVal().length)
                .forEach(function(name) {
                    meaningfulChooser.check(name, { silent: true })
                });
        } else {
            meaningfulChooser.uncheckAll();
        }

        this._onChange();
    },

    /**
     * Устанавливает попапу максимальную высоту.
     *
     * @protected
     */
    _setMaxHeight: function() {
        var drawingParams = this._popup.calcPossibleDrawingParams(),
            contentElem = this.findElem(this._popup.domElem, 'popup-content'),
            contentElemWidth = contentElem.outerWidth(),
            bestHeight = 0;

        drawingParams.forEach(function(params) {
            params.width >= contentElemWidth && params.height > bestHeight && (bestHeight = params.height);
        });

        if (bestHeight) {
            contentElem.css('max-height', bestHeight);

            this._popup.redraw();
        }
    },

    /**
     * Сбрасывает все подписки
     * @private
     */
    _dropSubMan: function() {
        if (this._subMan) {
            this._subMan.dispose();
            this._subMan.destruct();
            this._subMan = null;
        }
    },

    destruct: function() {
        this._dropSubMan();

        this.__base.apply(this, arguments);
    }

}, {

    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function(e) {
                this._onButtonClick(e);
            });
    }

});
