block('header-tabs').elem('ads')(

    def()(

        match(function() {
            return true;
        })(function() {
            return {
                elem: 'ads',
                url: apply('url'),
                text: apply('text'),
                active: apply('active'),
                needLogin: apply('needLogin')
            };
        }),

        match(function() {
            return hasLoginRights('super_control', 'superreader_control', 'placer_control', 'media_control',
                'support_control', 'limited_support_control', 'internal_ad_admin_control',
                'internal_ad_manager_control', 'internal_ad_superreader_control');
        })('')
    ),

    mode('isUserActsAsClient')(function() {
        return this.data.uname !== this.data.user_login;
    }),

    mode('url')(

        match(function() {
            return true;
        })(''),

        match(function() {
            return !this.data.mycamp_index;
        })(function() {
            return u.formatUrl({
                path: 'registered/main.pl',
                query: {
                    cmd: 'showCamps',
                    ulogin: apply('isUserActsAsClient') ? this.data.user_login : undefined
                }
            })
        }),

        match(function() {
            return hasLoginRights('agency_control');
        })(function() {
            return u.getUrl('showClients', {}, {
                suffix: ''
            });
        }),

        match(function() {
            return hasLoginRights('manager_control');
        })(function() {
            return u.getUrl('showManagerMyClients', {}, {
                suffix: ''
            });
        })
    ),

    mode('active')(function() {
        return this.data.mycamp && this.data.mycamp_index && !hasLoginRights('agency_control', 'manager_control') ||
            (!!~['showCamps', 'showClients', 'showManagerMyClients'].indexOf(this.data.cmd) ||
                this.data.cmd == 'showCamp' && !this.data.FORM.cid) &&
                    !this.data.FORM.ulogin;
    }),

    mode('needLogin')(function() {
        return !this.data.mycamp_index && !this.data.login_rights && this.data.ppcloginbox &&
            !this.data.has_media_camps;
    }),

    mode('text')(

        match(function() {
            return true;
        })(function() {
            return apply('isUserActsAsClient') ?
                iget2('header-tabs', 'kampanii-klienta', 'Кампании клиента') :
                iget2('header-tabs', 'moi-kampanii', 'Мои кампании');
        }),

        match(function() {
            return hasLoginRights('manager_control', 'agency_control');
        })(function() {
            return iget2('header-tabs', 'moi-klienty', 'Мои клиенты');
        })
    )
);
