block('header-tabs').elem('create')(

    def()(
        match(function() {
            return this.mods.type == 'direct';
        })(function() {
            return {
                elem: 'create',
                active: apply('active'),
                content: applyNext()
            };
        }),

        match(function() {
            return hasLoginRights(
                'placer_control', 'super_control', 'superreader_control',
                'media_control', 'support_control', 'limited_support_control', 'dont_show_new_camp_link_in_menu',
                'internal_ad_admin_control', 'internal_ad_manager_control', 'internal_ad_superreader_control'
            );
        })('')
    ),

    content().match(function() {
        return this.mods.type == 'direct';
    })(function() {
        return {
            block: 'b-choose-campaign-type',
            switcherMods: {
                theme: 'normal'
            },
            cmd: this.data.FORM.cmd,
            clientLogin: this.data.FORM.ulogin,
            loginRights: this.data.login_rights || {},
            userLogin: {},
            metrika: apply('metrika'),
            text: apply('text')
        };
    }),

    mode('metrika')(

        match(function() {
            return true;
        })(''),

        match(function() {
            return hasLoginRights('super_control', 'manager_control', 'agency_control');
        })('MDNADHEADYES'),

        match(function() {
            return !this.data.login_rights;
        }).match(function() {
            return this.data.ppcloginbox;
        })('MDNADHEADNO')),

    mode('text')(
        match(function() {
            return this.mods.type == 'direct';
        })(function() {
            return iget2('header-tabs', 'sozdat-kampaniyu', 'Создать кампанию');
        })
    ),

    //создание кампании в профи-интерфейсе
    mode('active')(function() {
        return /^(editCamp)$/.test(this.data.cmd) && this.data.new_camp ||
            //нулевой шаг
            /^(stepZero)$/.test(this.data.cmd) ||
            //добавить баннер в Баяне, создание первого баннера в кампании
            /^(addNewMediaBanner)$/.test(this.data.cmd) && this.data.from_newCamp ||
            // добавить группу в Директе, создание первой группы в кампании
            // eslint-disable-next-line max-len
            /^(addBannerMultiEdit|showCampMultiEdit|editAdGroupsMobileContent|addAdGroupsMobileContent|addAdGroupsPerformance|editAdGroupsPerformance|addDynamicAdGroups|editDynamicAdGroups)$/.test(this.data.cmd) &&
            (this.data.from_newCamp || this.data.FORM && this.data.FORM.from_newCamp);
    })
);
