block('header-tabs').elem('inventory')(

    def()(
        match(function() {
            return true
        })(function() {
            return {
                elem: 'inventory',
                url: apply('url'),
                text: apply('text'),
                active: apply('active')
            };
        }),

        match(function() {
            var hasFeature = u.consts('rights').enableCpmDealsCampaigns ||
                (hasLoginRights('agency_control') ?
                    this.data.cpm_deals_enabled_operator :
                    this.data.cpm_deals_enabled_client), // есть фича
                isAgencyHasEnabledDeals = !hasLoginRights('is_agency_limited') && hasLoginRights('agency_control'), // агенство, имеющее доступ к списку сделок
                isSuperAndIsPageShowClients = hasLoginRights('super_control') && this.data.cmd === 'showClients'; // cупер, на странице клиентов агенства
            return !(hasFeature && (isSuperAndIsPageShowClients || isAgencyHasEnabledDeals));
        })('')
    ),

    mode('url')(
        match(function() {
            return true;
        })(function() {
            return u.formatUrl({
                path: '/dna/deals',
                query: {
                    ulogin: this.data.cmd === 'showClients' ? u.consts('ulogin') : undefined
                }
            })
        })
    ),

    mode('active')(function() {
        return /context=deals/.test(decodeURIComponent(this.data.current_url))
    }),

    mode('text')(function() {
        var title = [
            iget2('header-tabs', 'private-deals2', 'Список сделок'),
        ];

        return title;
    })
);
