block('header-tabs').elem('recommendations')(
    def()(function() {
        return {
            elem: 'recommendations',
            url: apply('url'),
            text: apply('text'),
            active: apply('active')
        };
    }),

    match(function() {
        return !u['header-tabs'].isRecommendationAvailable();
    }).def()(''),

    mode('url')(function() {
        return u.formatUrl({
            path: '/dna/recommendations/',
            query: {
                ulogin: u.consts('ulogin')
            }
        });
    }),

    mode('active')(function() {
        // recommendations/grid не тоже самое что recommendations для шапки

        return /(recommendations)/.test(decodeURIComponent(this.data.current_url)) &&
            !/(recommendations-grid)/.test(decodeURIComponent(this.data.current_url));
    }),

    mode('text')(function() {
        return [
            iget2('header-tabs', 'recommendations', 'Рекомендации'),
            { block: 'header-recommendations-tooltip' }
        ];
    })
);
