block('header-tabs').elem('wordstat')(

    def().match(function() {
        var isInternalAdsSearch = [
            'showInternalAdsSearchPage',
            'internalAdsSearch'
        ].includes(this.data.cmd);

        return isInternalAdsSearch ||
            hasLoginRights('internal_ad_admin_control', 'internal_ad_manager_control', 'internal_ad_superreader_control');
    })(''),

    content()(function() {
        var data = this.data,
            domains = u.consts('domains'),
            curDomain = Object.keys(u._.pick(u.consts('domains'), function(elem) { return elem }))[0],
            yaDomain = {
                tr: 'yandex.com',
                ru: data.yandex_domain,
                com: data.yandex_domain,
                ua: data.yandex_domain
            }[curDomain] || 'yandex.ru';

        return {
            block: 'b-help-link',
            mods: {
                theme: 'normal',
                decoration: 'no',
                margin: 'no'
            },
            // Баяна на tt2, Директ в кокаине
            mix: u.consts('index') ? [{
                block: 'b-metrika',
                js: {
                    goal: data.login_rights ? 'MDNWORDYES' : 'MDNWORDNO'
                }
            }] : '',
            url: u.formatUrl({
                protocol: 'https',
                host: 'wordstat.' + yaDomain,
                query: {
                    direct: 1
                }
            }),
            windowParams: {
                name: 'advq',
                width: 870,
                height: 600
            },
            text: iget2('header-tabs', 'podbor-slov', 'Подбор слов')
        };
    })
);
