block('header-tabs').replace()(function() {

    return {
        block: 'tabs-menu',
        mods: { size: 'm', theme: 'head' },
        mix: [{ block: 'header-tabs', js: { agencyLogin: this.ctx.agencyLogin } , mods: this.mods }],
        content: (this.ctx.content || []).reduce(function(res, obj) {

            if (obj) {
                res.push({
                    elem: 'tab',
                    elemMods: { active: obj.active ? 'yes' : '' },
                    mix: [
                        {
                            block: 'header-tabs',
                            elem: obj.elem,
                            elemMods: obj.elemMods
                        },
                        obj.metrika ?
                            {
                                block: 'b-metrika',
                                js: { goal: obj.metrika }
                            } :
                            '',
                        obj.metrika2 ? {
                            block: 'b-metrika2',
                            js: obj.metrika2
                        } : ''
                    ],
                    content: obj.content || (obj.active ?
                        obj.text :
                        {
                            block: 'link',
                            mix: [
                                obj.needLogin ?
                                    {
                                        block: 'header-tabs',
                                        elem: 'need-login',
                                        js: { type: obj.elem }
                                    } :
                                ''
                            ],
                            url: obj.url,
                            target: obj.target,
                            content: obj.text
                        }
                    )
                });
            }

            return res;

        }, [])
    };

});
