BEM.DOM.decl('header-tabs', {
    onSetMod: {
        js: function() {
            if (u['header-tabs'].isRecommendationAvailable()) {
                BEM.blocks['b-metrika2'].reachGoal('recommendations_ShowLink');
            }

            var dna = window.dna;

            if (!dna) {
                return;
            }

            if (dna.utils && dna.utils.getQueryExecutor) {
                this._getDealsReceivedCount();
            }

            this._showRecommendationsTooltip();
        }
    },

    _getDealsReceivedCount: function() {
        var dna = window.dna,
            params = this.params,
            queryExecutor = dna.utils.getQueryExecutor(params.agencyLogin),
            inventoryElem = this.elem('inventory');

        if (inventoryElem.length && queryExecutor.getNewDealsCount) {
            queryExecutor.getNewDealsCount(params.agencyLogin).then(function(response) {
                if (response) {
                    BEM.DOM.append(inventoryElem, BEMHTML.apply({
                        block: 'ticker',
                        mix: {
                            block: 'header-tabs',
                            elem: 'deals-counter'
                        },
                        count: response
                    }));
                }
            }).catch(function(e) {
                //
            });
        }
    },

    _showRecommendationsTooltip: function() {
        this._recommendationsElem = this.elem('recommendations');
        var isTooltipHidden = window.dna.helpers.HeaderHelpers.isRecommendationsTooltipHidden();

        if (this._recommendationsElem.length && !isTooltipHidden) {
            var tooltip = this.findBlockInside(this._recommendationsElem, 'header-recommendations-tooltip');

            tooltip.show(this.findBlockInside(this._recommendationsElem, 'link'));
        }
    }
});
