BEM.DOM.decl('header2-balance-cart', {
    onSetMod: {
        js: function() {
            var dna = window.dna;

            this.login = this.params.login;
            var bPage = this.findBlockOn(BEM.DOM.scope, 'b-page');
            this.bPayBlock = bPage && bPage.findBlockInside('b-pay');
            this.walletCid = undefined;
            this.addAmount = undefined;

            if (!dna || !dna.components || !dna.components.BalanceCart || !dna.utils || !dna.utils.getQueryExecutor) {
                throw new Error('An error has occurred in loading DNA dependencies');
            }

            BEM.blocks['header2-balance-cart'].setBlock(this);

            var queryExecutor = dna.utils.getQueryExecutor(this.login),
                renderDna = this._renderDna.bind(this),
                self = this;

            BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
                queryExecutor.getBalanceCartData(this.login)
                    .then(function(balanceCartData) {
                        self.walletCid = balanceCartData.walletId;

                        // Есть "общий счет"
                        if (balanceCartData.walletId && balanceCartData.isB2bBalanceCartEnabled) {
                            BEM.blocks['header2-balance-cart'].setWalletCid(balanceCartData.walletId);

                            renderDna(dna);
                        }
                    })
                    .catch(function(e) {
                        // при ошибке загрузки walletCid ничего не делаем
                    });
            }.bind(this));
        }
    },

    _onComponentInited: function(triggerAddAmount) {
        this.addAmount = triggerAddAmount;
    },

    _onFirstDataLoaded: function(hasSinglePersonalAccount, serviceItems) {
        // Если корзина загружается на странице, где нет блока добавления суммы то ни чего не делаем
        if (!this.bPayBlock) {
            return;
        }

        var oldAmount = 0,
            walletCid = this.walletCid;

        if (serviceItems && serviceItems.length) {
            // items - массив объектов всех заказов пользователя [{qty , service_id , service_order_id }, {...}]
            // нужно найти данные по заказу директа (его может и не быть)
            var serviceData = serviceItems.find(function(item) {
                return Number(item.service_order_id) === Number(walletCid);
            });

            if (serviceData && serviceData.qty) {
                oldAmount = serviceData.qty;
            }
        }

        this.bPayBlock.trigger('balance-cart:first-data-loaded', {
            hasSinglePersonalAccount: hasSinglePersonalAccount,
            oldAmount: oldAmount
        });
    },

    _onAddAmount: function(amount) {
        this.bPayBlock.trigger('balance-cart:amount-added', {
            oldAmount: amount
        });
    },

    _onError: function(error) {
        // Ошибка при первом запросе (запрос за первичными данными корзины)
        if (error.method === 'list') {
            throw new Error('Balance cart error. Method: list, ' + 'message: ' + error.message);
        } else if (error.method === 'add') {
            // 2й и последующие запросы - добавление суммы в корзину
            this.bPayBlock.trigger('balance-cart:add-error');
        } else {
            throw new Error('Unhandled balance cart method')
        }
    },

    /**
     * Render DNA root component
     */
    _renderDna: function(dna) {
        var component = dna.components.BalanceCart,
            dnaRootComponent = dna.reactCreateElement(component, {
                host: this.params.host,
                onComponentInited: this._onComponentInited.bind(this),
                onFirstDataLoaded: this._onFirstDataLoaded.bind(this),
                onAddAmount: this._onAddAmount.bind(this),
                onError: this._onError.bind(this)
            }, null);

        dna.reactDOMRender(dnaRootComponent, this.domElem.get(0));
    }
}, {
    _block: undefined,

    setBlock: function(block) {
        this._block = block;
    },

    setWalletCid: function(walletCid) {
        this._walletCid = walletCid;
    },

    addAmount: function(amount, oldAmount) {
        if (!this._block.addAmount) {
            throw new Error('add method not found');
        }

        this._block.addAmount(amount, oldAmount, this._walletCid);
    }
});
