BEM.DOM.decl('header2-common-wallet', {
    onSetMod: {
        js: function() {
            this._initEvents();

            var dna = window.dna;

            if (!dna) {
                return;
            }

            if (dna.utils && dna.utils.getQueryExecutor) {
                BEM.DOM.blocks['b-state-dna'].awaitReady().then(function() {
                    this._updateJointAccount();
                }.bind(this));
            }
        }
    },

    _initEvents: function() {
        var buttonBlock = this.findBlockOn('button2');

        buttonBlock.on('click', function() {
            var goalParams = Object.create(null);
            goalParams.URL_common_wallet_click = document.location.href;

            BEM.blocks['b-metrika2'].reachGoal({
                target: 'COMMON_WALLET_CLICK',
                params: goalParams
            });
        });
    },

    _updateJointAccount: function() {
        var dna = window.dna,
            params = this.params,
            queryExecutor = dna.utils.getQueryExecutor(params.login),
            self = this;

        if (!params.login || !params.canAccessWallet) {
            return;
        }

        queryExecutor.getCommonWallet(params.login).then(function(response) {
            var buttonBlock = self.findBlockOn('button2');

            if (response.enabled) {
                if (response.sum <= 0) {
                    buttonBlock.findBlockInside('icon').setMod('type', 'white-money');
                    buttonBlock.setMod('tone', 'red');
                    buttonBlock.setMod('theme', 'raised');
                    buttonBlock.domElem[0].setAttribute('title', iget2(
                        'header2-common-wallet',
                        'wallet-link-no-money-hint',
                        'Пополните общий счет чтобы запустить ваши рекламные кампании'
                    ));
                }

                buttonBlock.elem('text').text(u.numberFormatter.format(response.sum) + ' ' + response.currency);
            }
        }).catch(function(e) {
             // при ошибке загрузки оставляем надпись "Общий счет" на кнопке
        });
    }
});
