/**
 * Ссылки под кнопкой со знаком вопроса в header
 *
 * requires fields in this.ctx
 * param lang {String}  установленный язык [ru, en, ....]
 * param helpUrl {String} url на "помощь"
 *
 */
block('header2').elem('help-menu').replace()(function() {
    /**
     * Пункты меню. Состав зависит от выранного языка у пользователя
     *
     * @const
     * @type {Array.<{ condition: String, elem: String, url: String, name: String }>}
     */
    var items = [
        {
            condition: /.*/im,
            elem: 'help',
            url: this.ctx.helpUrl,
            name: iget2('header2', 'help', 'Справка')
        },
        {
            condition: /ru/im,
            elem: 'news',
            url: 'https://yandex.ru/adv/news?tag=direkt',
            name: iget2('header2', 'news', 'Новости')
        },
        {
            condition: /en/im,
            elem: 'news',
            url: 'https://yandex.com/adv/news?tag=yandex-direct',
            name: iget2('header2', 'news', 'Новости')
        },
        {
            condition: /tr/im,
            elem: 'news',
            url: 'https://yandex.com.tr/adv/news?tag=yandex-direct',
            name: iget2('header2', 'news', 'Новости')
        },
        {
            condition: /ru/im,
            elem: 'training',
            url: 'https://yandex.ru/adv/edu?utm_source=direct&utm_medium=main_popup_question&utm_campaign=static',
            name: iget2('header2', 'obuchenie', 'Обучение')
        },
        {
            condition: /ru/im,
            elem: 'use-cases',
            // eslint-disable-next-line max-len
            url: 'https://yandex.ru/adv/story/cases/?utm_source=direct&utm_medium=main_popup_question&utm_campaign=static',
            name: iget2('header2', 'keysy', 'Кейсы')
        },
        {
            condition: /en/im,
            elem: 'training',
            // eslint-disable-next-line max-len
            url: 'https://yandex.com/adv/edu/direct-start?utm_source=direct&utm_medium=product-header&utm_campaign=static_en',
            name: iget2('header2', 'onlayn-kursy', 'Онлайн курсы')
        },
        {
            condition: /en/im,
            elem: 'use-cases',
            // eslint-disable-next-line max-len
            url: 'https://yandex.com/adv/story/cases?utm_source=direct&utm_medium=product-header&utm_campaign=static_en',
            name: iget2('header2', 'keysy', 'Кейсы')
        },
        {
            condition: /ua/im,
            elem: 'training',
            url: 'https://yandex.ua/adv/edu?utm_source=direct&utm_medium=product-header&utm_campaign=static_ua',
            name: iget2('header2', 'obuchenie', 'Обучение')
        },
        {
            condition: /tr/im,
            conditionDomain: 'tr',
            elem: 'training',
            // eslint-disable-next-line max-len
            url: 'https://yandex.com/adv/edu/direct-start?utm_source=direct&utm_medium=product-header&utm_campaign=static_tr',
            name: iget2('header2', 'obuchenie', 'Обучение')
        }
    ]
        .filter(function(item) {
            return item.conditionDomain ?
                u.consts('domains')[item.conditionDomain] && item.condition.test(this.lang) :
                item.condition.test(this.lang)
        }, this.ctx);

    return {
        block: 'dropdown-menu',
        mods: { user: 'yes' },
        mix: { block: 'header2', elem: 'help-menu' },
        content: [
            {
                elem: 'switcher',
                content: {
                    block: 'header2',
                    elem: 'action',
                    elemMods: { type: 'help' }, //      mix: [{ block: 'header2', elem: 'help-menu-switcher' }],
                    attrs: {
                        title: items
                            .map(function(item) {
                                return item.name;
                            })
                            .join(', ')
                    }
                }
            },
            {
                elem: 'popup',
                js: { directions: this['i-global'].login ? ['bottom'] : ['bottom-right'] },
                elemMods: { user: 'yes' },
                mix: [{
                    block: 'header2',
                    elem: 'help-menu-popup'
                }],

                content: items.map(function(item) {
                    return {
                        block: 'link',
                        target: '_blank',
                        url: item.url,
                        content: item.name
                    }
                })
            }
        ]
    };
});
