block('header2').mod('type', 'direct').match(function() {
    return this.data.cmd != 'proveNewAgencyClients';
})(

    mode('left')(function() {
        var data = this.data;
        return (applyNext() || []).concat(applyCtx({
            block: 'header-tabs',
            mods: {
                type: data.index_page || (data.is_public && !data.user_login) ? 'direct-morda' : 'direct'
            },
            agencyLogin: hasLoginRights('agency_control') && !u.consts('isMy') ?
                this['i-global'].raw_login :
                u.consts('ulogin')
        }));
    }),

    mode('right')(

        match(function() {
            return !(u.consts('domains')['tr'] && u.consts('lang') == 'en');
        })(function() {
            var data = this.data;

            return [{
                elem: 'help-menu',
                lang: data.lang,
                helpUrl: u.getCommonHelpUrl(data.is_promo_commander == 1 ? 'direct-commander' : 'direct')
            }]
                .concat(applyNext() || []);
        }),

        match(function() {
            return u.consts('domains')['tr'] && u.consts('lang') == 'en';
        })(function() {
            return [{
                elem: 'action',
                elemMods: {
                    type: 'help'
                },
                mix: [{
                    block: 'header2',
                    elem: 'help-menu'
                }],
                attrs: {
                    title: iget2('header2', 'help', 'Справка')
                },
                target: '_blank',
                url: u.getCommonHelpUrl(this.data.is_promo_commander == 1 ? 'direct-commander' : 'direct')
            }].concat(applyNext() || []);
        }),

        // Только для роли клиент (субклиент), только на bem-страницах, для работы с backend требуется как uid, так и
        // csrf_token (задается глобально и в блок явно не передается)
        match(function() {
            var data = this.data;

            return this['i-global'].login &&
                data.infoblock_enabled &&
                data.client_role === 'client' &&
                data.uid &&
                data.csrf_token;
        })(function() {
            var data = this.data,
                lang = u.consts('lang');

            if (lang == 'ua') {
                lang = 'uk';
            }

            return [
                {
                    block: 'b-infoblock',
                    mods: {
                        hidden: 'yes'
                    },
                    newsUrl: u.getNewsArchiveUrl(),
                    messagesURL: data.infoblock_messages_url,
                    newsFetchURL: data.infoblock_news_url,
                    ClientID: data.ClientID,
                    lang: lang,
                    autoExposeDisabled: data.fold_infoblock || hasLoginRights('agency_control'),
                    uid: data.uid,
                    euid: u.escapeHTML(data.UID),
                    miniDisabled: data.hide_teaser_stripe_ab
                }
            ].concat(applyNext() || []);
        }),

        match(function() {
            var role = this.data.login_rights && this.data.login_rights.role;
            return role === 'client' && (this.data.user_login || this.data.FORM.ulogin);
        })(function() {
            return [{
                block: 'header2-balance-cart',
                login: this.data.user_login || this.data.FORM.ulogin,
                host: this.data.BALANCE_CART_UI_URL
            }].concat(applyNext() || []);
        }),

        match(function() {
            return this['i-global'].login && this.data.cmd === 'showCamps';
        })(function() {
            return [
                {
                    block: 'b-grids-feedback',
                    mix: {
                        block: 'header2',
                        elem: 'grids-feedback'
                    }
                }
            ].concat(applyNext() || []);
        }),

        match(function() {
            var role = this.data.login_rights && this.data.login_rights.role,
                cmd = this.data.cmd,
                isReader = role === 'super' ||
                    role === 'superreader' ||
                    role === 'manager' ||
                    role === 'teamleader' ||
                    role === 'superteamleader' ||
                    role === 'agency' ||
                    role === 'support',
                isReaderNotOnClientPage = isReader && this.data.user_login !== this.data.uname;
            // не показываем медиапланнерам
            return role !== 'media' &&
                // не показываем плейсерам
                role !== 'placer' &&
                // не показываем на странице просмотра клиентов
                cmd !== 'showClients' &&
                // не показываем на странице поиска
                cmd !== 'showSearchPage' &&
                // не показываем на странице администрирования
                cmd !== 'adminPage' &&
                (!isReader || isReaderNotOnClientPage) &&
                this['i-global'].login &&
                this['i-global'].isClientOfDirect;
        })(function() {
            var data = this.data,
                firstCampaign = data.campaigns && data.campaigns[0],
                agencyID = firstCampaign ? firstCampaign.AgencyID : data.AgencyID;

            return [
                applyCtx({
                    block: 'header2-common-wallet',
                    mix: {
                        block: 'header2',
                        elem: 'wallet-link'
                    },
                    login: data.user_login || data.FORM.ulogin,
                    walletLink: u.getWalletLink(agencyID, { ulogin: data.FORM.ulogin }),
                    canAccessWallet: data.has_access_to_wallet === 0 ? false : true //чтобы не отправлять лишние запросы за кошельком DIRECT-94893
                })
            ].concat(applyNext() || []);
        })
    )

);
