block('header2')(
    elem('logo').replace()(function() {
        var lang = /en|tr/.test(u.consts('lang')) ? 'en' : 'ru',
            logoContent = lang === 'en' ?
                'borschik:include:../../desktop.blocks/header2/assets/header2-ya-logo-en.svg' :
                'borschik:include:../../desktop.blocks/header2/assets/header2-ya-logo-ru.svg';

        return {
            block: 'link',
            mix: [{ block: 'header2', elem: 'logo', elemMods: { lang: lang } }],
            url: this['i-services'].serviceUrl('www'),
            title: this.ctx.alt,
            content: logoContent,
            tabindex: -1
        };
    }),

    elem('service').replace()(function() {
        var lang = /en|tr/.test(u.consts('lang')) ? 'en' : 'ru',
            serviceContent = lang === 'en' ?
                'borschik:include:../../desktop.blocks/header2/assets/header2-direct-logo-en.svg' :
                'borschik:include:../../desktop.blocks/header2/assets/header2-direct-logo-ru.svg';

        return {
            block: 'link',
            mix: [{ block: 'header2', elem: 'service', elemMods: { lang: lang } }],
            url: '/',
            title: this.ctx.alt,
            content: serviceContent,
            tabindex: -1
        };
    }),

    elem('uid').match(function() { return u.consts('uid'); })(
        content()(function() {
            return [
                {
                    elem: 'uid-label',
                    content: 'UID:'
                },
                '&nbsp;' + u.escapeHTML(u.consts('uid'))];
        })
    ),

    elem('client-id').match(function() { return this.ctx.clientId; })(
        content()(function() {
            return u.escapeHTML(this.ctx.clientId);
        })
    )
);
