block('header2')(
    def()(function() {
        var ctx = this.ctx,
            mods = ctx.mods || {},
            type = this['i-global']['id'];

        mods.type || (mods.type = type);
        mods.beta || (mods.beta = u.consts('is_beta') ? 'yes' : undefined);

        this.ctx.mods = mods;

        return applyNext({
            mods: mods,
            'ctx.left': apply('left', { mods: mods }),
            'ctx.right': apply('right', { mods: mods })
        });
    }),

    mode('left')(function() {
        return [
            this.data.cmd !== 'errorPage' && {
                block: 'b-tableau-trigger',
                mix: [{
                    block: 'header2',
                    elem: 'tableau-opener'
                }],
                attrs: {
                    title: iget2('header2', 'tablo-servisov', 'Табло сервисов')
                },
                parentName: 'header2'
            },
            {
                elem: 'logo',
                alt: iget2('b-header2', 'yandeks', 'Яндекс'),
            },
            {
                elem: 'service',
                alt: iget2('header2', 'direkt', 'Директ')
            }
        ];
    }),

    mode('right')(

        match(function() {
            return true;
        })(function() {
            return [];
        }),

        match(function() {
            return this['i-global'].login;
        })(function() {
            var data = this.data,
                global = this['i-global'],
                roleName = u.getRoleNameForHead(data.login_rights),
                // для bem-шапки на tt2 страницах инитим стор для обновления csrf-токена,
                // т.к. из js шапки дёргаются graphql-ные запросы.
                // На чисто BEM-страницах стор инитится вызовом StateWrapper.initStor в b-page
                needDnaStoreInit = this.ctx.needDnaStoreInit;

            return [{
                elem: 'direct',
                content: [
                    {
                        elem: 'user-name',
                        elemMods: {
                            fake: data.real_login ? 'yes' : undefined
                        },
                        attrs: {
                            title: iget2('header2', 'avtorizovan-kak', 'авторизован как')
                        }
                    },
                    {
                        block: 'user2',
                        uid: global.UID,
                        yu: global.yandexuid,
                        name: global.login,
                        retpath: global.retpath,
                        passportHost: global['passport-host'],
                        avatarId: data.display_name ? data.display_name.avatar['default'].content : null,
                        origin: 'direct',
                        logoutOrigin: 'direct',
                        actionsMenu: [],
                        mods: {
                            'fetch-accounts': 'yes',
                            'with-pin-code': 'yes'
                        },
                        js: {
                            accountsMax: 100
                        },
                        mix: [{
                            block: 'header2',
                            elem: 'user'
                        }]
                    },
                    roleName && {
                        elem: 'role',
                        content: roleName
                    },
                    hasLoginRights('agency_control') ?
                        { elem: 'client-id', clientId: data.login_rights.ClientID } :
                        data.is_beta ? { elem: 'uid' } : '',
                    needDnaStoreInit ?
                        {
                            block: 'b-state-dna',
                            ulogin: data.user_login || data.FORM.ulogin,
                            cspNonce: data.csp_nonce,
                            page: this.data.FORM.cmd,
                            isGridEnabled: false,
                            csrfToken: this.data.csrf_token,
                            clientFeatures: [],
                            operatorFeatures: []
                        } :
                        null
                ]
            }];
        }),

        match(function() {
            return !this['i-global'].login;
        }).match(function() {
            return !/^(errorPage|showSurveySuccess)$/.test(this.data.cmd);
        })(function() {
            var title = iget2('header2', 'voyti', 'Войти');

            return {
                block: 'button',
                mods: { size: 'm', theme: 'pseudo' },
                mix: [{ block: 'header2', elem: 'enter' }],
                attrs: {
                    tabindex: '-1',
                    title: title
                },
                url: u.formatUrl({
                    protocol: this.data.SCRIPT_OBJECT.protocol,
                    host: this.data.passport_domain,
                    path: '/auth',
                    query: {
                        origin: 'direct',
                        retpath: this.data.is_public ?
                            this['i-global'].retpath :
                            this.data.index_page ? this.data.cur_page : u.getCurrentUrl()
                    }
                }, true),
                content: [
                    {
                        block: 'image',
                        mix: [{ block: 'button', elem: 'icon', elemMods: { 16: 'enter' } }],
                        alt: ''
                    },
                    {
                        block: 'header2',
                        elem: 'enter-label',
                        content: title
                    }
                ]
            };
        })
    )
);
