(function() {
    // по умолчанию таймзона для Москвы
    var DEFAULT_TIMEZONE_ID = 130,
        DEFAULT_TIMEZONE_TEXT = iget2('i-adapter-time-targeting', 'moskva', 'Москва'),

        DEFAULT_HOLIDAY_SHOWING_FROM = 8,
        DEFAULT_HOLIDAY_SHOWING_TO = 20,
        DEFAULT_HOLIDAY_SHOWING_COEFFICIENT = 100;

    u.register({

        'i-adapter-time-targeting': {

            /**
             * Генерирует дефолтные входные данные для блока `b-time-targeting`
             * @param {Object} data
             * @param {Object[]} data.timezone_groups серверные данные временных зон
             * @param {String} [preset='other']
             * @returns {{timeZoneGroups: *, isExtendModeAvailable: boolean, value: {isExtendModeOn: boolean, timeZone: {id: number, text: *}, timeTargetCode: *, isHolidaySettingsEnabled: boolean, isWorkingWeekendEnabled: boolean, holidayShowSettings: {isShowing: boolean, showingFrom: number, showingTo: number, coefficient: number}, preset: *}}}
             */
            getDefault: function(data, preset) {
                preset || (preset = 'other');

                return {
                    timeZoneGroups: data.timezone_groups,
                    isExtendModeAvailable: false,
                    value: {
                        isExtendModeOn: false,
                        timeZone: {
                            id: DEFAULT_TIMEZONE_ID,
                            text: DEFAULT_TIMEZONE_TEXT
                        },
                        timeTargetCode: u['b-time-targeting'][preset === 'all' ? 'CODE_ALL_TIME' : 'CODE_WORK_TIME'],
                        isHolidaySettingsEnabled: false,
                        isWorkingWeekendEnabled: preset !== 'all',
                        holidayShowSettings: {
                            isShowing: true,
                            showingFrom: DEFAULT_HOLIDAY_SHOWING_FROM,
                            showingTo: DEFAULT_HOLIDAY_SHOWING_TO,
                            coefficient: DEFAULT_HOLIDAY_SHOWING_COEFFICIENT
                        },
                        preset: preset,
                        showWorkingWeekendCheckbox: true
                    }
                };
            },

            /**
             * Преобразует серверные данные по временному таргетингу во входные блока `b-time-targeting`
             * @param {Object} data
             * @returns {Object}
             */
            fromServer: function(data) {
                var timeZoneGroups = data.timezone_groups,
                    campaign = data.campaign,
                    timeTargeting = campaign.timetargeting,
                    strategy = campaign.strategy,
                    isExtendModeAvailable = strategy && !+strategy.is_autobudget &&
                        !u.campaign.isCpm(campaign.mediaType), // DIRECT-75136
                    showingFrom = +timeTargeting.time_target_holiday_from,
                    showingTo = +timeTargeting.time_target_holiday_to,
                    isTurkishClient = data.is_turkish_client || false;

                return {
                    timeZoneGroups: timeZoneGroups,
                    isExtendModeAvailable: isExtendModeAvailable,
                    value: {
                        isExtendModeOn: isExtendModeAvailable && timeTargeting.timeTargetMode === 'extend',
                        timeZone: {
                            id: timeTargeting.timezone_id || DEFAULT_TIMEZONE_ID,
                            text: timeTargeting.timezone_text || DEFAULT_TIMEZONE_TEXT
                        },
                        timeTargetCode: timeTargeting.timeTarget || u['b-time-targeting'].CODE_ALL_TIME,
                        isHolidaySettingsEnabled: !!+timeTargeting.time_target_holiday || false,
                        isWorkingWeekendEnabled: !!+timeTargeting.time_target_working_holiday || false,
                        holidayShowSettings: {
                            isShowing: !(+timeTargeting.time_target_holiday_dont_show),
                            showingFrom: showingFrom || (showingFrom === 0) ?
                                showingFrom :
                                DEFAULT_HOLIDAY_SHOWING_FROM,
                            showingTo: showingTo || (showingTo === 0) ?
                                showingTo :
                                DEFAULT_HOLIDAY_SHOWING_TO,
                            coefficient: +timeTargeting.time_target_holiday_coef || DEFAULT_HOLIDAY_SHOWING_COEFFICIENT
                        },
                        showWorkingWeekendCheckbox: !isTurkishClient,
                        preset: timeTargeting.time_target_preset || 'other'
                    }
                };
            },

            /**
             * Преобразует значение блока `b-time-targeting` в серверные данные по временному таргетингу
             * @param {Object} timeTargetingValue
             * @returns {Object}
             */
            toServer: function(timeTargetingValue) {
                var holidaySettings = timeTargetingValue.holidayShowSettings,
                    timeZone = timeTargetingValue.timeZone,
                    processingValue = {
                        timeTarget: timeTargetingValue.timeTargetCode,
                        timeTargetMode: timeTargetingValue.isExtendModeOn ? 'extend' : 'simple',
                        time_target_holiday: timeTargetingValue.isHolidaySettingsEnabled ? 1 : 0,
                        time_target_holiday_dont_show: holidaySettings.isShowing ? 0 : 1,
                        time_target_working_holiday: timeTargetingValue.isWorkingWeekendEnabled ? 1 : 0,
                        time_target_holiday_coef: holidaySettings.coefficient,
                        time_target_holiday_from: holidaySettings.showingFrom,
                        time_target_holiday_to: holidaySettings.showingTo,
                        time_target_preset: timeTargetingValue.preset,
                        timezone_id: timeZone.id,
                        timezone_text: timeZone.text
                    };

                // Приводим все значения к строке, потому что `b-hidden` не воспринимает в качестве значения число `0`
                u._.forEach(processingValue, function(value, key) {
                    processingValue[key] = '' + value;
                });

                return processingValue;
            }
        }

    });

})();
