(function() {

    /**
     * Метод для создания окна с капчей, вернут BEM окно
     * @param {String} captchaUrl ссылка на картинку капчи
     * @param {String} captchaId идентификатор капчи
     * @returns {BEM}
     */
    function createModal(captchaUrl, captchaId) {
        var bemjson = {
            block: 'popup',
            mods: {
                position: 'fixed',
                type: 'modal',
                autoclosable: 'no',
                'body-scroll': 'no'
            },
            underMods: { type: 'paranja' },
            content: [
                {
                    elem: 'content',
                    content: {
                        block: 'b-ajax-captcha',
                        title: iget2('i-ajax-captcha', 'prevyshen-limit-zaprosov', 'Превышен лимит запросов'),
                        captchaId: captchaId,
                        imgUrl: captchaUrl
                    }
                }
            ]
        };

        return BEM.DOM.init($(BEMHTML.apply(bemjson)))
            .appendTo('body')
            .bem('popup');
    }

    // Глобальный обработчик ошибок ajax-запросов для отлова капч
    $(document).ajaxError(function(e, jqxhr, settings) {

        var data,
            modal,
            captchaId,
            captchaUrl;

        // 429 ошибка с капчей
        // если не она, то выходим отсюда
        if (jqxhr.status !== 429) return;

        // Проверяем не является ли запрос запросом новой капчи
        // это нужно потому как, если пользователь забанен по карме,
        // на этот запрос ему тоже вывалится 429я ошибка
        // поэтому надо выйти из глобального обработчика и предоставить
        // разрулить ситуацию блоку b-ajax-captcha
        if (settings.url.indexOf('cmd=showCaptcha') > -1) return;

        // пробуем распарсить json в ответе
        try {
            data = $.parseJSON(jqxhr.responseText);
        } catch (error) {
            // если не получилось, то выходим
            return;
        }

        captchaId = data.captcha_id;
        captchaUrl = data.captcha_url;

        // парсим отправленные данные
        settings.data = u.parseUrl(
            '?' + decodeURIComponent(settings.data).replace(/\+/g, ' ')).query;

        modal = createModal(captchaUrl, captchaId);

        // по отправке формы капчи
        modal.findBlockInside('b-ajax-captcha').on('submit', function(event, edata) {
            //удаляем поля капчи из урла
            settings.url = settings.url.replace(/&?captcha(_code)?(_id)?=[^&]*/g, '');
            // а потом добавляем в настройки, чтоб на сервер с основным запросом
            // ушла информация о капче
            $.extend(settings.data || (settings.data = {}), {
                captcha_code: edata.captchaCode,
                captcha_id: edata.captchaId
            });

            // прячем и уничтожаем окно
            modal.hide();
            modal.destruct();

            // отправляет заново изначальный запрос, но с информацией о капче
            $.ajax(settings);
        });

        modal.show();

        modal.findBlockInside('input').setMod('focused', 'yes');
    });

})();
