(function() {
    BEM.decl('i-autobroker', {}, {
    /*jshint -W015*/

            /*
             * Охват аудитории на тематических площадках
             */
        calcContextCoverage: function(price, pokazometerData) {
            if (!pokazometerData || !pokazometerData.shows_list || pokazometerData.shows_list.length < 1) { return 0; }

            var mass = prepareMass(pokazometerData.shows_list, 'cost', 'cnt');

                //если все показы были с ценой выше нашей, то покрытие 0%
            if (price < mass[0].x) return 0;

            return interpolateLinear(price, mass) / (pokazometerData.shows_cnt || 1)

        },

        calcRetargCoverage: function(price, hitsByCost) {
            var length = hitsByCost.length,
                clicks = 0;

                //если все показы были с ценой выше нашей, то покрытие 0%
            if (price < hitsByCost[0].price) {
                return 0;
            } else if (price >= hitsByCost[length - 1].price ) {
                return 1;
            }

            for (var i = 0; i < length; i++) {
                if (price < hitsByCost[i].price) {
                    clicks = hitsByCost[i - 1].shows;
                    break;
                }
            }
            return clicks / ((hitsByCost[length - 1].shows))
        },

        calcContextPriceByCoverage: function(cov, pokazometerData) {
            if (!pokazometerData || !pokazometerData.shows_list || pokazometerData.shows_list.length < 1) { return 0; }
            var cnt = pokazometerData.shows_cnt * (cov / 100),
                mass = prepareMass(pokazometerData.shows_list, 'cnt', 'cost');

            return interpolateLinear(cnt, mass);
        }
    });

    function calcCoverage(effPrice, prices, probs) {
        if (prices.length < 2 || prices.length != probs.length || effPrice < prices[0]) return 0;

        // находим, между какими элементами попадает цена
        var i = binarySearch(effPrice, prices),
            lowPrice,
            highPrice,
            k;

        // не учитываем последний элемент
        i = Math.min(prices.length - 1, i);
        // индекс предыдущего элемента (если указатель не на первом)
        i = Math.max(0, i - 1);

        lowPrice = prices[i];
        highPrice = prices[i + 1] >= effPrice ? prices[i + 1] : effPrice;

        k = (effPrice - lowPrice) / ((highPrice - lowPrice) || 1);

        return probs[i] + k * (probs[i + 1] - probs[i]);
    }

    function binarySearch(value, array) {
        var low = 0,
            high = array.length,
            mid;

        while (low < high) {
            mid = (low + high) >> 1;
            array[mid] < value ? low = mid + 1 : high = mid;
        }

        return low;
    }

    function interpolateLinear(val, mass) {
        var prev = mass[0],
            current;

        for (var i = 0; i < mass.length; i++) {
            current = mass[i];
            if (val > +current.x) {
                prev = current;
            } else {
                return (prev.x - current.x) != 0 ?
                    /*jshint -W007*/
                    (prev.y - current.y) * (val - current.x) / (prev.x - current.x) + +current.y :
                    +prev.y;
            }
        }

        return prev.y;
    }

    function prepareMass(mass, x, y) {
        var result = [];

        for (var i = 0; i < mass.length; i++) {
            result.push({ x: mass[i][x], y: mass[i][y] })
        }
        result = result.sort(function(a, b) {

            return +a.x > +b.x ? 1 : +a.x < +b.x ? -1 : 0;
        });

        return result;
    }

})();
