BEM.decl('i-autopayment-dataprovider', {
}, {
    /**
     * Отправляет запрос на возобновление попытки включить автоплатеж после ошибки
     * @param {String} walletCid номер кошелька
     * @returns {Promise}
     */
    resumeAutopayment: function(walletCid) {
        var _this = this;

        return new Promise(function(resolve, reject) {
            var request = _this._getRequest();

            request.get({
                cmd: 'ajaxResumeAutopay',
                wallet_cid: walletCid,
                ulogin: u.consts('ulogin'),
                csrf_token: u.consts('csrf_token')
            },function(data) {
                resolve(data);
            }, function(data) {
                reject(data);
            });
        });
    },

    /**
     * Возвращает экземпляр блока i-request_type_ajax
     * @param {Object} [params] параметры запроса
     * @returns {BEM}
     * @private
     */
    _getRequest: function(params) {

        return BEM.create('i-request_type_ajax', u._.extend({
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            cache: false,
            callbackCtx: this
        }, params));
    }
});
