BEM.decl('i-banner-all-formats-opener', {

    /**
     * @typedef {Object} AllFormatsOptions - дополнительные опции превью
     * @param {BEM.DOM} [parent] - ссылка на родительский popup
     * @param {String} [activeTab] - название активного таба
     * @param {Number} clientId - id клиента
     */

    /**
     * Показать попап с табами превью
     * @param {AllFormatsOptions} [options] дополнительные опции
     * @param {Object} data - данные баннера // TODO попробывать избавиться от view данных тут: DIRECT-63755
     * @param {Object} data.mediaType - тип кампании
     * @param {Object} data.bannerData - данные дата модели баннера
     * @param {DataToPcode} data.bannerPcodeData - данные view модели баннера
     */
    setPreview: function(options, data) {
        var bannerData = data.bannerData || {},
            dna = window.dna,
            clientFeatures = u.consts('clientFeaturesAll');

        if (!dna) {
            throw new Error('An error has occurred in loading DNA dependencies');
        }

        options = options || {};

        dna.reactDOMRender(dna.reactCreateElement(
            dna.components.FullscreenPreviewGalleryWrapper, {
                login: u.consts('ulogin'),
                bannerId: bannerData.bid,
                campaignId: options.cid,
                canvasDomain: u.consts('canvasUiUrl'),
                clientId: options.clientId,
                cspNonce: BEM.blocks['i-global'].param('nonce'),
                clientFeatures: clientFeatures,
                operatorFeatures: u.consts('operatorFeaturesAll')
            }, null), options.parent.domElem[0]);
    },

    /**
     * Получение данных для превью всех форматов в сетях
     * @param {DataToPcode} bannerPcodeData
     * @return {Object}
     * @private
     */
    _getContextPreviewData: function(bannerPcodeData) {
        return {
            banner: bannerPcodeData.ads[0]
        }
    },

    /**
     * Получение данных для превью видео
     * @param {AllFormatsOptions} options
     * @param {DataToPcode} bannerPcodeData - данные баннера
     * @param {Object} bannerData - данные баннера (из DM)
     * @return {{autostart: boolean, url: *, banner: *}}
     * @private
     */
    _getVideoPreviewData: function(options, bannerPcodeData, bannerData) {
        var videoResources = bannerData.video_resources || {},
            hasVideoMotion = !bannerData.disable_videomotion &&
                !!bannerData.image_model && bannerData.image_model.image,
            url = videoResources.live_preview_url || (hasVideoMotion && u.formatUrl({
                host: u.consts('canvasUiUrl'),
                path: 'video-additions/video-motion/preview',
                query: { compact: 1, client_id: options.clientId }
            }));

        return {
            autostart: options.activeTab === 'video',
            url: url,
            banner: bannerPcodeData.ads[0]
        };
    },

    /**
     * Проверка доступно ли видеопревью
     * @param {Object} bannerData - данные баннера (из DM)
     * @return {Boolean}
     * @private
     */
    _isContextPreviewEnabled: function(bannerData) {
        return bannerData.ad_type === 'text';
    },

    /**
     * Проверка доступно ли видеопревью
     * @param {Object} bannerData - данные баннера (из DM)
     * @return {Boolean}
     * @private
     */
    _isVideoPreviewEnabled: function(bannerData) {
        return bannerData.ad_type === 'text';
    },

    destruct: function() {
        return this.__base.apply(this, arguments);
    }

}, {

    /**
     * Возвращает попап для страницы всех видов РСЯ
     * @returns {BEM.DOM}
     * @private
     */
    _getPopup: function() {
        if (!this._sharedPopup) {
            this._sharedPopup = BEM.blocks['b-shared-popup'].getInstance(
                {
                    type: 'modal',
                    position: 'fixed',
                    'has-close': 'yes',
                    'content-adaptive': 'yes',
                    'body-scroll': 'no'
                },
                {},
                { popup: { block: 'i-banner-all-formats-opener', elem: 'popup' } },
                { type: 'paranja' }
            );

            this._sharedPopup.on('hide', function() {
                var previewsBlock = this._sharedPopup.findBlockInside('b-banner-all-formats');
                previewsBlock && previewsBlock.destruct();
            }, this);
        }

        return this._sharedPopup;
    },

    /**
     * Создает инстанс блока и возвращает его
     * @param {AllFormatsOptions} [options] дополнительные опции
     * @param {Object} data - данные баннера // TODO надо чтобы тут не было данных view модели
     * @param {Object} data.bannerData - данные дата модели баннера
     * @param {Object} data.bannerPcodeData - данные view модели баннера
     * @return {*|BEM}
     */
    showBannerAllFormats: function(options, data) {
        this._instance || (this._instance = BEM.create('i-banner-all-formats-opener'));
        this._instance.setPreview(options, data);

        return this._instance;
    }

});
