u.register({

    'i-banner-data': {
        /**
         * Модифицирует данные баннера дефолтными и рассчитываемыми значениями
         * @param {Object} params
         * @param {Object} params.banner
         * @param {String} params.count
         * @param {Object} params.dmParams
         * @param {String} params.groupModelId
         * @param {String} params.adgroup_type
         * @param {Object} data
         */
        patch: function(params, data) {
            var banner = params.banner,
                groupId = params.groupModelId || 'new',
                count = params.count,
                loginRights = data.login_rights,
                pixels = banner.pixels || [],
                audience = u._.find(pixels, { kind: 'audience' }) || {},
                audits = u._.filter(pixels, { kind: 'audit' });

            banner.audience = audience.url || '';
            banner.audits = audits && u._.map(audits, 'url');

            banner.newBannerIndex = count + 1;
            // DIRECT-45288 была проблема с пересечениями modelId у баннеров из разных групп (newN)
            banner.modelId = +banner.bid ? banner.bid : groupId + '-new' + banner.newBannerIndex; // для клиентов показываем отсчёт новых баннеров с 1
            banner.cid = data.campaign.cid || 'new';

            // DIRECT-61150 если с сервера не приходит протокол, пытаемся взять из href
            banner.url_protocol = banner.url_protocol || u.getUrlProtocol(banner.href) || 'https://';

            banner.dmParams = {
                name: params.dmParams && params.dmParams.banner || 'm-banner',
                id: banner.modelId
            };

            if (params.adgroup_type == 'mobile_content' && !banner.primary_action) {
                banner.primary_action = 'download';
            }

            if (!banner.bid) {
                banner.disable_videomotion = params.adgroup_type == 'text' ? false : true;
            }

            if (u._.isEmpty(banner.banner_type)) {
                banner.banner_type = data.campaign.mediaType == 'mobile_content' ? 'mobile' : 'desktop';
            }

            if (banner.vcard && !Object.keys(banner.vcard).filter(function(name) {
                return !!banner.vcard[name] && banner.vcard[name] !== null;
            }).length) {
                delete banner.vcard;
            }

            if (banner.vcard && !banner.vcard.org_details) {
                banner.vcard.org_details = {
                    ogrn: banner.vcard.ogrn,
                    org_details_id: banner.vcard.org_details_id
                }
            }

            banner = u.bannerData({
                banner: banner,
                //флаг о том, что мы находимся на "оригинальной" странице редактирования, а не вернулись с шага со ставками / не вернулись с ошибкой
                isFirstLoad: !!data.FORM.json_groups,
                ci_hidden: data.campaign.OPTIONS && data.campaign.OPTIONS.ci_hidden,
                has_accepted_vcard: data.has_accepted_vcard
            });

            //Баннер скопирован в оптимизированные
            banner.isStatusOptimized = data.optimize_camp &&
                data.optimize_camp.optimized_banners[banner.bid] &&
                data.if_user_can_optimize_campaign && data.optimizing_not_ready;

            banner.isRejectByModerator = data.optimize_camp &&
                (loginRights.super_control || loginRights.media_control) &&
                    data.optimize_camp.mod_reasons && banner.mbid && data.optimize_camp.mod_reasons[banner.mbid];

            if (typeof banner.age === 'undefined') {
                banner.age = banner.hash_flags && banner.hash_flags.age;
            }

            banner.showAdminAttrs = data.FORM.debug && data.is_internal_ip &&
                (loginRights.super_control || loginRights.superreader_control);

            //есть право переключать возрастное ограничение
            banner.canToggleAge = loginRights.super_control || loginRights.support_control ||
                loginRights.placer_control;

            return banner;
        }
    }

});
