/**
 * @typedef {Object} VideoExtensionFormat формат видео
 * @property {String} id
 * @property {String} delivery
 * @property {String} type
 * @property {Number} bitrate
 * @property {Number} width
 * @property {Number} height
 * @property {String} url
 *
 * @typedef {Object} VideoExtension данные видеодополнения
 * @property {String} id идентификатор видеодополнения
 * @property {String} name название видеодополнения
 * @property {VideoExtensionFormat[]} urls массив объектов видео
 */
BEM.decl('i-banner-media-extensions-data', {
    onSetMod: {
        js: function() {
            // набор медиа дополнений, возможных для прикрепления к баннеру
            this._resources = this.params.resources;
        }
    },

    /**
     * Возвращает новый объект видеодополнения выбранный случайным образом из установленного набора видеодополнений
     * @returns {VideoExtension}
     */
    getVideo: function() {
        return u._.sample(this._resources.video || []) || {}
    }

});
