describe('i-banner-media-extensions-data', function() {
    var sandbox,
        block,
        resourcesData = {
            video: [
                {
                    id: 1,
                    name: 'test',
                    type: 'video'
                },
                {
                    id: 2,
                    name: 'test2',
                    type: 'video'
                }
            ]
        };

    function createBlock(options) {
        options || (options = {});

        return u.getInitedBlock({
            block: 'i-banner-media-extensions-data',
            js: options.js || {}
        })
    }

    beforeEach(function() {
        sandbox = sinon.sandbox.create({});
    });

    afterEach(function() {
        sandbox.restore();
    });

    describe('Метод getVideo', function(){

        afterEach(function() {
            block.destruct && block.destruct();
        });

        it('Возвращает любое видео из массива', function() {
            block = createBlock({
                js: {
                    resources: resourcesData
                }
            });

            expect(block.getVideo()).to.have.property('id')
        });

        it('Возвращает пустой объект, если массив пуст', function() {
            block = createBlock({
                js: {
                    resources: {
                        video: []
                    }
                }
            });

            expect(block.getVideo()).to.deep.eq({})
        });
    });
});

