u.register({

    'i-banners-group-data': {

        /**
         *
         * @param {Object} params
         * @param {Object} params.bannersGroup
         * @param {Array} params.campaignTags
         * @param {Number} params.count
         * @param {Object} params.isCopyGroup
         * @param {String} params.cid
         * @param {Object} params.isSingleGroup
         * @param {Object} params.isNewGroup
         * @param {Object} params.isCopyGroup
         * @param {Object} params.hasPrevBanner
         * @param {Object} params.prevBanner
         * @param {Object} params.dmParams
         * @param {Boolean} params.isBannersEditable
         * @param {Boolean} params.isDevicesEnabled
         * @param {Boolean} params.isWithoutDeviceRestrictions
         * @param {Object} data
         * @return {Object}
         */
        patch: function(params, data) {
            var group = params.bannersGroup,
                tagIds = group.tag_ids || '',
                campaignTags = params.campaignTags,
                loginRights = data.login_rights;

            //adgroup_id приходит строкой
            group.adgroup_id = +group.adgroup_id;
            // cyn@TODO: DIRECT-45870: унести на серверсайд
            group.adgroup_type === 'base' && (group.adgroup_type = 'text');
            group.newGroupIndex = params.count + 1;

            //для создания новой группы или копирования/мультикопирования групп
            group.modelId = group.adgroup_id && !params.isCopyGroup ? group.adgroup_id : 'new' + group.newGroupIndex;
            group.dmParams = {
                name: u.campaign.getGroupModelName(data.campaign.mediaType),
                id: group.modelId
            };

            group.has_general_limit_price = !data.campaign.strategy.is_autobudget;

            group.cid = group.cid || params.cid;
            group.isSingleGroup = params.isSingleGroup;
            group.isNewGroup = params.isNewGroup;
            group.isCopyGroup = params.isCopyGroup;

            group.bannersCount = group.banners_quantity;

            group.banners.forEach(function(banner, i) {
                //подробно логика пока "скопировать из предыдущего" см в DIRECT-38880
                if (banner.ad_type) {
                    if (banner.ad_type === 'mcbanner') {
                        // для ГО на поиске убираем копирование из предыдущего баннера (по ФТ)
                        banner.hasCopyFromPrev = false;
                    } else {
                    // нельзя скопировать данные баннера другого типа, если баннер был уже сохранен на сервере
                        banner.hasCopyFromPrev = group.isSingleGroup && params.hasPrevBanner &&
                            (banner.isNewBanner || params.prevBanner.ad_type === banner.ad_type) ||
                                (i > 0 && !!u._.findLast(group.banners, function(item, index) {
                                    return item.ad_type === banner.ad_type && index < i &&
                                    // если графический баннер был уже сохранен на сервере,
                                    // то копировать можно только данные баннера такого же формата
                                    (banner.isNewBanner || banner.ad_type !== 'image_ad' ||
                                        (banner.image_ad && item.image_ad &&
                                            banner.image_ad.width == item.image_ad.width &&
                                                banner.image_ad.height == item.image_ad.height) ||
                                        (banner.creative && item.creative &&
                                            banner.creative.width == item.creative.width &&
                                                banner.creative.height == item.creative.height)
                                    );
                                }));
                    }
                } else {
                    banner.hasCopyFromPrev = group.isSingleGroup && (params.hasPrevBanner) || (i > 0);
                }

                // DIRECT-39276 - поля statusModerate и statusPostModerate - поля группы, но пользоваться ими надо в баннере
                // (для блока b-banner-status), подобная логике есть в утилитах групп при обработке данных, полученных
                // по ручке getAdGroup (например, m-group.utils.js:transformBannerData) DIRECT-49050
                banner.groupStatusModerate = group.statusModerate;
                banner.groupStatusPostModerate = group.statusPostModerate;

                // DIRECT-47806 - поля мобильного контента группы, нужны в баннере для b-banner-status
                if (group.mobile_content) {
                    banner.isAvailableMobileContent = !!+group.mobile_content.is_available;
                    // для группы, содержащей только графические баннеры иконка приложения показываться не будет
                    // поэтому и статус модерации иконки игнорируется (DIRECT-56773)
                    banner.ignoreIconStatusModerate = u.imageAd.groupHasOnlyCpcVideoAndImageAds(
                        group.group_banners_types
                    );
                    banner.iconStatusModerate = group.mobile_content.icon_status_moderate;
                    banner.icon_hash = group.mobile_content.icon_hash;
                }

                banner = u['i-banner-data'].patch({
                    banner: banner,
                    count: i,
                    dmParams: params.dmParams,
                    adgroup_type: group.adgroup_type,
                    groupModelId: group.modelId
                }, data);
            });

            //показываем ограничения для уже существующих групп с фразами или ретаргетингами
            //если фраз или ретаргетингов не существует, то выставлять ограничение не на что
            group.showAgeLabels = !(group.isNewGroup || group.isCopyGroup) &&
                (group.phrases && group.phrases.length || group.retargetings && group.retargetings.length);
            group.isBannersEditable = params.isBannersEditable;

            group.isNotEmptyGroup = group.banners_quantity > 0;

            //у баннера нет свойства banners_quantity
            group.isEmptyGroup = !group.isNotEmptyGroup;

            //для работы с группами в которых всегда один баннер
            //cyn@ переехало в параметры попапа групп, для РМП пока остается
            group.firstBid = group.banners[0] && group.banners[0].bid || 'new';

            group.canViewImageId = !!(loginRights.super_control || loginRights.superreader_control ||
                loginRights.support_control || loginRights.limited_support_control ||
                loginRights.placer_control);

            // преобразовываем данные корректировки ставок для группы объявлений

            u['i-adjustment-rates-data'].patchMultipliers(group, {
                multipliers_meta: u._.get(data.campaign, 'multipliers_meta') || u._.get(data, 'multipliers_meta'),
                isDevicesEnabled: params.isDevicesEnabled,
                isWithoutDeviceRestrictions: params.isWithoutDeviceRestrictions
            });

            return group;
        }

    }

});
