(function(BEM, $, undefined) {

    $.inheritSelf(BEM, {

        /**
         * Retrieves name/value for a list of modifiers
         * @private
         * @param {Array} modNames Names of modifiers
         * @param {Object} [elem] Element
         * @returns {Object} Hash of modifier values by name
         * NOTICE: метод не правильно работает для блоков без DOM представления
         * При вызове метода getMods затирается кэш _modCache и модификаторы блока более недоступны
         */
        _extractMods: function(modNames, elem) {

            return modNames.length ?
                modNames.reduce(function(mods, name) {
                    mods[name] = this._modCache[name];
                }.bind(this), {}) :
                this._modCache;
        }

    });

})(BEM, jQuery, undefined);
