/**
 * Источник данных для подсказки имен кампаний.
 * Не ходит на сервер за данными, массив имен кампаний передается в параметрах блока.
 */
BEM.decl('i-camp-names-suggest-dataprovider', {
    /**
     * Проверяет является ли переданное значение частью названия кампании или ее идентификатора,
     * вызывает колбек с найденными именами кампаний.
     * В campTitle строки вида "111 - campaign name" (id кампании - название)
     *
     * @param {String} val
     * @param {Function} onSuccess
     * @returns {Array}
     */
    get: function(val, onSuccess) {

        if (!val) return onSuccess([]);

        onSuccess(this.params.callbackCtx.params.campTitle.filter(function(name) {
            return name.toLowerCase().indexOf((val + '').toLowerCase()) != -1;
        }));
    }
});
