/**
 * @typedef {Object} CampaignsCopySuccessResponse ответ на запрос копирования кампаний при успехе
 * @property {Number} result всегда равен 1
 * @property {Number} result_time_estimate оценка времени завершения операции, в минутах
 */

/**
 * @typedef {Object} CampaignsCopyErrorResponse ответ на запрос копирования кампаний при ошибке
 * @property {Array<BackendValidationError[]|null>} errors массив массивов ошибок, в каждом элементе - список ошибок на кампанию или null, если ошибок для соответствующей кампании нет
 */

BEM.decl('i-campaign-request', {}, {
    /**
     * Совершает запрос на копирование кампаний
     * @param {String[]} cids идентификаторы кампаний для копирования
     * @param {String} ulogin логин пользователя, которому принадлежат кампании
     * @returns {Deferred<CampaignsCopySuccessResponse|CampaignsCopyErrorResponse,jqXHR>}
     */
    copy: function(cids, ulogin) {
        return BEM.create('i-direct-request').getAsJq({
            cmd: 'copyCampClient',
            cid: cids.join(','),
            ulogin: ulogin
        });
    }
});
