(function() {
    /**
     * Возвращает сообщение об ошибке соответствующее переданному типу и для переданных кампаний
     * @param {String} type идентификатор типа ошибки
     * @param {String[]} cids идентификаторы кампаний
     * @returns {String}
     */
    var getCopyErrorMessageByErrorType = function(type, cids) {
            var types = {
                    AlreadyInCopyQueue: function(cids) {
                        return cids.length > 1 ?
                            iget2(
                                'i-campaign',
                                'kampanii-s-uzhe-nahodyatsya',
                                'Кампании {foo} уже находятся в очереди для копирования. Пожалуйста, дождитесь завершения операции.',
                                {
                                    foo: cids.join(', ')
                                }
                            ) :
                            iget2(
                                'i-campaign',
                                'kampaniya-s-uzhe-nahoditsya',
                                'Кампания {foo} уже находится в очереди для копирования. Пожалуйста, дождитесь завершения операции.',
                                {
                                    foo: cids[0]
                                }
                            );
                    },
                    AlreadyInCampQueue: function(cids) {
                        return cids.length > 1 ?
                            iget2(
                                'i-campaign',
                                'kampanii-s-uzhe-nahodyatsya-100',
                                'Кампании {foo} уже находятся в обработке. Пожалуйста, дождитесь завершения операции.',
                                {
                                    foo: cids.join(', ')
                                }
                            ) :
                            iget2(
                                'i-campaign',
                                'kampaniya-s-uzhe-nahoditsya-101',
                                'Кампания {foo} уже находится в обработке. Пожалуйста, дождитесь завершения операции.',
                                {
                                    foo: cids[0]
                                }
                            );
                    },
                    CampaignArchived: function(cids) {
                        return cids.length > 1 ?
                            iget2('i-campaign', 'kampanii-s-nahodyatsya-v', 'Кампании {foo} находятся в архиве и не могут быть скопированы.', {
                                foo: cids.join(', ')
                            }) :
                            iget2('i-campaign', 'kampaniya-s-nahoditsya-v', 'Кампания {foo} находится в архиве и не может быть скопирована.', {
                                foo: cids[0]
                            });
                    },
                    NoBanners: function(cids) {
                        return cids.length > 1 ?
                            iget2('i-campaign', 'v-kampaniyah-s-net', 'В кампаниях {foo} нет баннеров для копирования.', {
                                foo: cids.join(', ')
                            }) :
                            iget2('i-campaign', 'v-kampanii-s-net', 'В кампании {foo} нет баннеров для копирования.', {
                                foo: cids[0]
                            });
                    },
                    AccessDenied: function(cids) {
                        return cids.length > 1 ?
                            iget2('i-campaign', 'dostup-k-kampaniyam-s', 'Доступ к кампаниям {foo} запрещен.', {
                                foo: cids.join(', ')
                            }) :
                            iget2('i-campaign', 'dostup-k-kampanii-s', 'Доступ к кампании {foo} запрещен.', {
                                foo: cids[0]
                            });
                    },
                    InvalidCampaignType: function(cids) {
                        return cids.length > 1 ?
                            iget2(
                                'i-campaign',
                                'nevozmozhno-skopirovat-kampanii-s',
                                'Невозможно скопировать кампании {foo}, потому что они имеют неверный тип.',
                                {
                                    foo: cids.join(', ')
                                }
                            ) :
                            iget2(
                                'i-campaign',
                                'nevozmozhno-skopirovat-kampaniyu-s',
                                'Невозможно скопировать кампанию {foo}, потому что она имеют неверный тип.',
                                {
                                    foo: cids[0]
                                }
                            );
                    },
                    LimitExceeded: function(cids) {
                        return cids.length > 1 ?
                            iget2(
                                'i-campaign',
                                'kampanii-s-ne-mogut',
                                'Кампании {foo} не могут быть скопированы. Превышено допустимое количество кампаний.',
                                {
                                    foo: cids.join(', ')
                                }
                            ) :
                            iget2(
                                'i-campaign',
                                'kampaniya-s-ne-mozhet',
                                'Кампания {foo} не может быть скопирована. Превышено допустимое количество кампаний.',
                                {
                                    foo: cids[0]
                                }
                            );
                    }
                },
                typeFn = types[type] || function(cids) {
                    return cids.length > 1 ?
                        iget2('i-campaign', 'ne-udalos-skopirovat-kampanii', 'Не удалось скопировать кампании {foo}.', {
                            foo: cids.join(', ')
                        }) :
                        iget2('i-campaign', 'ne-udalos-skopirovat-kampaniyu', 'Не удалось скопировать кампанию {foo}.', {
                            foo: cids[0]
                        });
                };

            return typeFn(cids);
        },
        /**
         * Возвращает сагрегированное сообщение об ошибке про неудачу копирования кампаний
         * @param {String[]} cids идентификаторы кампаний из запроса
         * @param {Array<BackendValidationError[]|null>} errors ошибки кампаний
         * @returns {String} html сообщения
         */
        getCopyErrorsMessage = function(cids, errors) {
            // ошибки в ответе возвращаются в том же порядке, что и переданные идентификаторы, связываем их
            var errorsList = u._.flatten(errors.map(function(campaignErrors, index) {
                    return campaignErrors != null ?
                        campaignErrors.map(function(error) {
                            error.cid = cids[index];

                            return error;
                        }) :
                        null;
                }).filter(Boolean)), // для кампаний без ошибок в массиве ответа - null, отсеиваем их
                errorGroups = u._.groupBy(errorsList, function(error) { return error.name; });

            return Object.keys(errorGroups).map(function(name) {
                var cids = errorGroups[name].map(function(error) { return error.cid; });

                return getCopyErrorMessageByErrorType(name, cids);
            }).join('<br>');
        },
        /**
         * Возвращает строку времени ожидания копирования
         * @param {Number} time время, в минутах
         * @returns {String}
         */
        getCopyEstimateString = function(time) {
            if (time > 60 * 2) { // не показываем время большее 2 часов
                time = 60 * 2;
            }

            return u.moment.duration(time, 'minutes').humanize(true);
        };

    BEM.decl('i-campaign', {}, {
        /**
         * Копирует кампании с переданными идентификаторами
         * @param {String[]} cids идентификаторы кампаний
         * @param {String} ulogin логин пользователя, которому принадлежат кампании
         * @returns {Deferred<{ message: String, isSuccessfull: boolean },jqXHR>} объект с сообщением о результате операции
         */
        copyCamps: function(cids, ulogin) {
            return BEM.blocks['i-campaign-request'].copy(cids, ulogin).then(function(res) {
                if (res.result) {
                    return {
                        message: iget2(
                            'i-campaign',
                            'zakazano-kopirovanie-num-pyati',
                            'Заказано копирование {num}, новые кампании появятся в списке {time}.',
                            {
                                num: function() {
                                    return u.pluralize([iget2('i-campaign', 'kampanii', 'кампании'), iget2('i-campaign', 'kampaniy', 'кампаний'), iget2('i-campaign', 'kampaniy', 'кампаний')], cids.length);
                                }(iget2('i-campaign', 'zakazano-kopirovanie-num-pyati-param-num', 'пяти кампаний')),

                                time: function() {
                                    return getCopyEstimateString(res.result_time_estimate);
                                }(iget2('i-campaign', 'zakazano-kopirovanie-num-pyati-param-time', 'через 3 минуты')),

                                context: 'num - пяти кампаний; time - через 3 минуты'
                            }
                        ),
                        isSuccessfull: true
                    };
                } else if (res.generic_errors && res.generic_errors.length) { //generic_errors и array_errors - взаимоисключающие
                    return {
                        message: res.generic_errors.map(function(error) {
                            return getCopyErrorMessageByErrorType(error.name, cids);
                        }).join('<br>'),
                        isSuccessfull: false
                    };
                } else if (res.array_errors && res.array_errors) {
                    return {
                        message: getCopyErrorsMessage(cids, res.array_errors),
                        isSuccessfull: false
                    };
                } else {
                    return $.Deferred().reject();
                }
            });
        }
    });

}());
