describe('i-campaign', function() {
    describe('i-campaign.copyCamps()', function() {
        var makeCopyStub = function(response) {
            return sinon.stub(BEM.blocks['i-campaign-request'], 'copy').returns($.Deferred().resolve(response));
        };

        it('должна группировать сообщения об ошибках из array_errors по их типу', function() {
            var copyStub = makeCopyStub({
                array_errors: [
                    [
                        { name: 'AlreadyInCopyQueue' },
                        { name: 'CampaignArchived' }
                    ],
                    [
                        { name: 'AlreadyInCopyQueue' }
                    ],
                    null
                ]
            });

            return BEM.blocks['i-campaign'].copyCamps([1, 2, 3], 'user').then(function(res) {
                copyStub.restore();
                expect(res.message).to.be.eql('Кампании 1, 2 уже находятся в очереди для копирования. Пожалуйста, дождитесь завершения операции.<br>Кампания 1 находится в архиве и не может быть скопирована.');
            });
        });

        it('должна возвращать сообщения из generic_errors без группировки', function() {
            var copyStub = makeCopyStub({
                generic_errors: [
                    {
                        "name" : "LimitExceeded"
                    }
                ]
            });

            return BEM.blocks['i-campaign'].copyCamps([1, 2, 3], 'user').then(function(res) {
                copyStub.restore();
                expect(res.message).to.be.eql('Кампании 1, 2, 3 не могут быть скопированы. Превышено допустимое количество кампаний.');
            });
        });

        it('должна возвращать сообщения из array_errors если в ответе есть пустой generic_errors', function() {
            var copyStub = makeCopyStub({
                generic_errors: [],
                array_errors: [
                    [
                        { name: 'AlreadyInCopyQueue' }
                    ]
                ]
            });

            return BEM.blocks['i-campaign'].copyCamps([1], 'user').then(function(res) {
                copyStub.restore();
                expect(res.message.length).to.be.above(0);
            });
        });

        it('при успехе должна возвращать сообщения об успехе с ожидаемым временем выполнения операции', function() {
            var copyStub = makeCopyStub({
                result: 1,
                result_time_estimate: 20
            });

            return BEM.blocks['i-campaign'].copyCamps([1], 'user').then(function(res) {
                copyStub.restore();
                expect(res.message).to.be.eql('Заказано копирование 1 кампании, новые кампании появятся в списке через 20 минут.');
            });
        });

        it('не должна возвращать время ожидания в сообщении большее 2 часов', function() {
            var copyStub = makeCopyStub({
               result: 1,
               result_time_estimate: 10000
            });

            return BEM.blocks['i-campaign'].copyCamps([1], 'user').then(function(res) {
                copyStub.restore();
                expect(res.message).to.be.eql('Заказано копирование 1 кампании, новые кампании появятся в списке через 2 часа.');
            });
        });
    });
});
