block('i-const')(
    mode('extendConsts')(function() {
        var data = this.data,
            currencies = data.CONSTS.currencies;
        if (data.customMinPay) { // эксперимент с миниальной суммой оплаты только для рублей
            currencies['RUB']['MIN_PAY'] = Number(data.customMinPay);
        }
        if (data.customRecommendWarnSumm) {
            // Переопределяем RECOMMENDATION_SUM_WARN для рублей значением с бека, которое приходит по проперте
            // Включаем в DIRECT-149354
            // После включения выпиливаем в DIRECT-149770
            currencies['RUB']['RECOMMENDATION_SUM_WARN'] = Number(data.customRecommendWarnSumm);
        }
        if (data.OVERWRITED_RECOMMENDATION_SUM_MIN) {
            // эксперимент с переопределением минимальной суммы в саджесте только для рублей DIRECT-148810
            currencies['RUB']['RECOMMENDATION_SUM_MIN'] = Number(data.OVERWRITED_RECOMMENDATION_SUM_MIN);
            currencies['RUB']['RECOMMENDATION_SUM_MID'] = 25000;
            currencies['RUB']['RECOMMENDATION_SUM_MAX'] = 45000;
        }

        this.extendConsts({
            currencies: data.CONSTS.currencies,
            pseudo_currency: data.pseudo_currency,
            fixed_currency_rates: data.CONSTS.fixed_currency_rates,
            currency_texts_description: data.CONSTS.currency_texts_description,
            currencies_order: data.CONSTS.currencies_order
        });

        return applyNext();
    }),

    mode('public-params')(
        match(function() {
            return this.name === 'currencies';
        })(true),
        match(function() {
            return this.name === 'pseudo_currency';
        })(true),
        match(function() {
            return this.name === 'fixed_currency_rates';
        })(true),
        match(function() {
            return this.name === 'currency_texts_description';
        })(true),
        match(function() {
            return this.name === 'currencies_order';
        })(true))
);
