block('i-const')(

    mode('extendConsts')(function() {
        var data = this.data,
            userTypeSuper = hasLoginRights('super_control'),
            isRecommendationSupported = (/context=(grid|recommendations|recommendations-grid)/
                .test(decodeURIComponent(data.current_url)) && data.cmd === 'showDna') || data.cmd !== 'showDna',
            isTechInAppEventsInRmpEnabled = hasLoginRights('manager_control', 'super_control'),
            features_enabled_for_client = data.features_enabled_for_client || {},
            features_enabled_for_client_all = data.features_enabled_for_client_all;

        this.extendConsts({
            edgeOn: userTypeSuper,
            visible_futures: data.visible_futures,
            isRecommendationSupported: isRecommendationSupported,
            enableWCTR: false,
            isModerationsOfferFeatureEnabled: !features_enabled_for_client.facelift_disabled_for_dna,
            hidePayWithCash: !!features_enabled_for_client.pay_with_cash_disabled,
            isSupportChatEnabled: data.lang === 'ru' &&
                (features_enabled_for_client.support_chat ||
                    (!!data.show_support_chat && !features_enabled_for_client.facelift_disabled_for_dna)) &&
                !hasLoginRights('internal_ad_admin_control', 'internal_ad_manager_control', 'internal_ad_superreader_control'),
            isTechInAppEventsInRmpEnabled: isTechInAppEventsInRmpEnabled ,
            isUserInAppEventsInRmpEnabled: !!features_enabled_for_client.in_app_events_in_rmp_enabled,
            isRelevanceMatchForNewGroupsEnabledByDefault:
                !!features_enabled_for_client.relevance_match_for_new_groups_enabled,
            enabledChangeOfferForClientsFromTurkey:
                !!features_enabled_for_client.enabled_change_offer_for_clients_from_turkey && data.yandex_domain == 'yandex.com.tr',
            isDefaultAutobudgetAvgCpaEnabled: !!features_enabled_for_client.default_autobudget_avg_cpa,
            isDefaultAutobudgetOptimizeClicksEnabled:
                !!features_enabled_for_client.default_autobudget_avg_click_with_week_budget,
            isDefaultAutobudgetRoiEnabled: !!features_enabled_for_client.default_autobudget_roi,
            isEditAvgCpmPeriodStrategyWithoutRestartEnabled:
                Boolean(+features_enabled_for_client.edit_avg_cpm_without_restart),
            isCpaPayForConversionsMobileContentStrategyAllowed:
                !!features_enabled_for_client.is_has_cpa_pay_for_conversions_mobile_apps_allowed,
            isCpaPayForConversionsExtendedModeStrategyAllowed:
                !!features_enabled_for_client.is_cpa_pay_for_conversions_extended_mode_allowed,
            isLandingsWizardAllowed: !!features_enabled_for_client.landings_wizard_allowed,
            isMassEditRegionsInDnaEnabled: !!features_enabled_for_client.mass_edit_regions_for_dna_enabled,
            isFeatureBrandSafetyEnabled: !!features_enabled_for_client.brandsafety_enabled,
            isFeatureBrandSafetyAdditionalCategoriesEnabled:
                !!features_enabled_for_client.brandsafety_additional_categories,
            isMobileAppGoalsForTextCampaignAllowed:
                !!features_enabled_for_client.has_mobile_app_goals_for_text_campaign_allowed,
            isMobileAppGoalsForTextCampaignStrategyEnabled:
                !!features_enabled_for_client.mobile_app_goals_for_text_campaign_strategy_enabled,
            isFeatureDemographyBidModifierUnknownAgeAllowed:
                !!features_enabled_for_client.is_demography_bid_modifier_unknown_age_allowed,
            isMobileOsBidModifierEnabled: !!features_enabled_for_client.mobile_os_bid_modifier_enabled,
            isTurboPageTypesInMolEnabled: !!features_enabled_for_client.turbo_page_types_enabled_in_mol,
            relevanceMatchCategoriesStatWarnsEnabled: !!features_enabled_for_client.relevance_match_categories_stat_warns_enabled,
            isIncomeGradeBidModifierEnabled: !!features_enabled_for_client.income_grade_bid_modifier_allowed,
            isCpcDeviceModifiersEnabled: hasEnabledFeatures('cpc_device_modifiers'),
            isLalSegmentsEnabled: !!features_enabled_for_client.lal_segments_enabled,
            isRetargetingOnlyLalEnabled: !!features_enabled_for_client.retargeting_only_lal_enabled,
            conversionStrategyLearningStatusEnabled:
                !!features_enabled_for_client.conversion_strategy_learning_status_enabled,
            turboAppAllowed: !!features_enabled_for_client.turbo_app_allowed,
            isCpvStrategiesEnabled: !!features_enabled_for_client.cpv_strategies_enabled,
            isSimplifiedStrategyViewEnabled: !!features_enabled_for_client.simplified_strategy_view_enabled,
            increasedCpaLimitForPayForConversion:
                !!features_enabled_for_client.increased_cpa_limit_for_pay_for_conversion,
            isCanvasRangeRatioCpcEnabled:
                !!features_enabled_for_client.canvas_range_ratio_cpc,
            showConversionReportForLogin: features_enabled_for_client.show_conversion_report_for_login,
            isTelegramEnabled:
                !!features_enabled_for_client.telegram_enabled,
            crrStrategyAllowed: !!features_enabled_for_client.crr_strategy_allowed,
            newCashPaymentEnabled: !!features_enabled_for_client.new_cash_payment_enabled,
            brandsafetyBaseCategoriesStat: !!features_enabled_for_client.brandsafety_base_categories_stat,
            isPromocodeHintEnabled: !!data.is_promocode_hint_enabled,
            clientFeaturesAll: features_enabled_for_client_all,
            operatorFeaturesAll: data.features_enabled_for_operator_all,
            isSearchRetargetingEnabled: features_enabled_for_client_all && features_enabled_for_client_all.includes('SEARCH_RETARGETING_ENABLED_ON_SHOW_CAMP'),
            isEditTinEnabledInUserSettings: features_enabled_for_client_all && features_enabled_for_client_all.includes('EDIT_TIN_IN_USER_SETTINGS'),
            isPercOfImpDisabled: features_enabled_for_client_all && features_enabled_for_client_all.includes('PERC_OF_IMP_DISABLED'),
            isModulesRecommendationsDnaEnabled: features_enabled_for_client_all && features_enabled_for_client_all.includes('MODULES_RECOMMENDATIONS_DNA_ENABLED'),
            isPostviewConversionsReportEnabled: features_enabled_for_client_all && features_enabled_for_client_all.includes('POSTVIEW_CONVERSIONS_REPORT'),
            isEnableVideoHintsSettings: features_enabled_for_client_all && features_enabled_for_client_all.includes('ENABLE_VIDEO_HINTS_SETTINGS'),
            isCampaignEditPageVideoHints: features_enabled_for_client_all && features_enabled_for_client_all.includes('CAMPAIGN_EDIT_PAGE_VIDEO_HINTS'),
        });

        return applyNext();
    }),

    mode('public-params')(
        match(function() {
            return this.name === 'edgeOn';
        })(true),
        match(function() {
            return this.name === 'visible_futures';
        })(true),
        match(function() {
            return this.name === 'enableWCTR';
        })(true),
        match(function() {
            return this.name === 'isRecommendationSupported';
        })(true),
        match(function() {
            return this.name === 'isUserInAppEventsInRmpEnabled';
        })(true),
        match(function() {
            return this.name === 'isTechInAppEventsInRmpEnabled';
        })(true),
        match(function() {
            return this.name === 'isSupportChatEnabled';
        })(true),
        match(function() {
            return this.name === 'isRelevanceMatchForNewGroupsEnabledByDefault';
        })(true),
        match(function() {
            return this.name === 'isLandingsWizardAllowed';
        })(true),
        match(function() {
            return this.name === 'isDefaultAutobudgetAvgCpaEnabled';
        })(true),
        match(function() {
            return this.name === 'isDefaultAutobudgetOptimizeClicksEnabled';
        })(true),
        match(function() {
            return this.name === 'isDefaultAutobudgetRoiEnabled';
        })(true),
        match(function() {
            return this.name === 'isMassEditRegionsInDnaEnabled';
        })(true),
        match(function() {
            return this.name === 'isFeatureBrandSafetyEnabled';
        })(true),
        match(function() {
            return this.name === 'isFeatureBrandSafetyAdditionalCategoriesEnabled';
        })(true),
        match(function() {
            return this.name === 'isMobileAppGoalsForTextCampaignAllowed';
        })(true),
        match(function() {
            return this.name === 'isMobileAppGoalsForTextCampaignStrategyEnabled';
        })(true),
        match(function() {
            return this.name === 'isFeatureDemographyBidModifierUnknownAgeAllowed';
        })(true),
        match(function() {
            return this.name === 'isMobileOsBidModifierEnabled';
        })(true),
        match(function() {
            return this.name === 'isTurboPageTypesInMolEnabled';
        })(true),
        match(function() {
            return this.name === 'relevanceMatchCategoriesStatWarnsEnabled';
        })(true),
        match(function() {
            return this.name === 'isIncomeGradeBidModifierEnabled';
        })(true),
        match(function() {
            return this.name === 'isCpcDeviceModifiersEnabled';
        })(true),
        match(function() {
            return this.name === 'isTelegramEnabled';
        })(true),
        match(function() {
            return this.name === 'isCpaPayForConversionsExtendedModeStrategyAllowed';
        })(true),
        match(function() {
            return this.name === 'isLalSegmentsEnabled';
        })(true),
        match(function() {
            return this.name === 'turboAppAllowed';
        })(true),
        match(function() {
            return this.name === 'isCpvStrategiesEnabled';
        })(true),
        match(function() {
            return this.name === 'isCpaPayForConversionsMobileContentStrategyAllowed';
        })(true),
        match(function() {
            return this.name === 'isModerationsOfferFeatureEnabled';
        })(true),
        match(function() {
            return this.name === 'isSimplifiedStrategyViewEnabled';
        })(true),
        match(function() {
            return this.name === 'increasedCpaLimitForPayForConversion';
        })(true),
        match(function() {
            return this.name === 'isCanvasRangeRatioCpcEnabled';
        })(true),
        match(function() {
            return this.name === 'hidePayWithCash';
        })(true),
        match(function() {
            return this.name === 'crrStrategyAllowed';
        })(true),
        match(function() {
            return this.name === 'newCashPaymentEnabled';
        })(true),
        match(function() {
            return this.name === 'isRetargetingOnlyLalEnabled';
        })(true),
        match(function() {
            return this.name === 'brandsafetyBaseCategoriesStat';
        })(true),
        match(function() {
            return this.name === 'isPromocodeHintEnabled';
        })(true),
        match(function() {
            return this.name === 'clientFeaturesAll';
        })(true),
        match(function() {
            return this.name === 'operatorFeaturesAll';
        })(true),
        match(function() {
            return this.name === 'isSearchRetargetingEnabled';
        })(true),
        match(function() {
            return this.name === 'isEditTinEnabledInUserSettings';
        })(true),
        match(function() {
            return this.name === 'isModulesRecommendationsDnaEnabled';
        })(true),
        match(function() {
            return this.name === 'isPostviewConversionsReportEnabled';
        })(true)
    )
);
