block('i-const')(

    mode('extendConsts')(function() {
        var data = this.data,
            login_rights = data.login_rights,
            isTurkishClient = data.is_turkish_client || data.yandex_domain == 'yandex.com.tr',
            featuresEnabledForClient = data.features_enabled_for_client || {},
            featuresEnabledForOperator = data.features_enabled_for_operator || {},
            allOperatorFeatures = data.features_enabled_for_operator_all,
            controlClients = data.mcc && data.mcc.clients || [];

        function withTrueOrUndefined(object) {
            var allFalse = Object.keys(object).every(function(key) {
                return object[key] === false;
            });

            if (allFalse) return;

            return object;
        }

        this.extendConsts({
            rights: {
                cpmAudioEnabled: !!featuresEnabledForOperator.cpm_audio,

                //флаг, разрешающий создание динамических медийных кампаний
                createDynamicMediaCampaigns:
                    //суперпользователям и менеджерам Смарт-баннеры доступны всегда
                    hasLoginRights('super_control', 'manager_control') ||
                    //Для НЕ-Турции Смарт-баннеры доступны всем
                    !isTurkishClient,
                //флаг, разрешающий использование уже созданных Смарт-баннеров - в том числе просмотр списков смарт-баннеров и фидов
                //Смарт-баннеры доступны всем, у кого уже есть смарт-баннеры
                useDynamicMediaCampaigns: !!data.has_performance_campaigns ||
                    //суперпользователям и менеджерам Смарт-баннеры доступны всегда
                    hasLoginRights('super_control', 'manager_control') ||
                    //Для НЕ-Турции Смарт-баннеры доступны всем
                    !isTurkishClient,

                ajaxAdGroupsMultiSave: !!data.java_backend || ((data.campaign || {}).mediaType === 'cpm_banner') ||
                    ((data.campaign || {}).mediaType === 'cpm_deals') ||
                    ((data.campaign || {}).mediaType === 'cpm_yndx_frontpage') ||
                    ((data.campaign || {}).mediaType === 'content_promotion'),

                // showCampMultiEdit
                canEditDomain: hasLoginRights('super_control', 'support_control', 'placer_control', 'manager_control'),

                // создание ДО
                createDynamicCampaigns: !isTurkishClient || hasLoginRights('super_control'),

                // флаг, разрешающий управление настройками в сетях для динамических кампаний
                manageContextForDynamicCampaigns: hasLoginRights(
                    'super_control',
                    'manager_control',
                    'support_control',
                    'placer_control',
                    'is_superteamleader',
                    'is_teamleader'),

                //флаг, позволяющий выбирать тип бизнеса у фида
                useBusinessType: hasLoginRights('super_control'),

                // отчеты по ДРФ доступны только для внутренних ролей
                useAdditionalPhrasesReports: hasLoginRights(
                    'super_control', 'support_control', 'manager_control', 'superreader_control',
                    'placer_control', 'media_control', 'is_superteamleader', 'is_teamleader'),

                // enableCpmCampaigns: data.enable_cpm_banner_campaigns,
                enableCpmCampaigns: true,

                enableCpmYndxFrontpageCampaigns: !isTurkishClient,

                enableCpmDealsCampaigns: !!data.enable_cpm_deals_campaigns,

                enableInternalCampaigns: !!data.enable_internal_campaigns,

                enableStatsMultiClientsMode: !!data.multi_clients_mode && !data.is_mcc,

                enableMcc: allOperatorFeatures && allOperatorFeatures.includes('CLIENT_MCC') && controlClients.length > 0,

                // Фича про открытие охватных метрик в МОЛ
                enableCpmStatistics: hasEnabledFeatures('cpm_fixed_data_in_mol'),

                // Вторая фича про открытие охватных метрик в МОЛ, у которых пока данные пока не корректные
                enableCpmStatistics2: hasEnabledFeatures('cpm_additional_data_in_mol'),

                // Разрешает показ переключателя на новый интерфейс.
                allowSwitchToDNA: data.grid_allowed,

                isDnaHeaderAndSidebarEnabled:
                    !data.index_page &&
                    data.features_enabled_for_client && (
                        Boolean(+data.features_enabled_for_client.is_grid_enabled) ||
                        Boolean(+data.features_enabled_for_client.is_hide_old_show_camps) ||
                        Boolean(+data.features_enabled_for_client.is_show_dna_by_default)
                    ),

                enableVideoInMobileCampains: !!(this.data.features_enabled_for_client || {})
                    .mobile_content_cpc_video_allowed || hasLoginRights('super_control', 'manager_control'),

                // Разрешен просмотр рекомендаций
                allowRecommendations: !!data.enable_recommendations,

                // Разрешено создание видео баннеров в ТГО
                allowedCpcVideoBanners: !!data.is_feature_cpc_video_banner_enabled,

                allowedCpmVideoBanners: true,

                // Показывать BannerID (БК-шный) + версию
                showBannerIdInfo: hasLoginRights('super_control', 'support_control', 'is_developer', 'superreader_control'),

                mobileContentCpcVideoAllowed: !!featuresEnabledForClient.mobile_content_cpc_video_allowed,

                enableContentPromotion: !!featuresEnabledForClient.content_promotion_video ||
                    !!featuresEnabledForClient.content_promotion_collection,

                // Разрешено создавать кампании продвижения контента на Яндекс.Видео
                enableContentPromotionVideo: !!featuresEnabledForClient.content_promotion_video,

                // Разрешено создавать группы продвижения контента в Яндекс.Коллекциях
                enableContentPromotionCollection: !!featuresEnabledForClient.content_promotion_collection,

                // Разрешено создавать объявления "баннер в Яндекс.Метро"
                cpmGeoProductEnabled: !!featuresEnabledForClient.cpm_geoproduct_enabled,

                // Разрешено несколько пикселей для баннеров групп CPM_VIDEO
                cpmVideoSeveralPixelsEnabled: !!featuresEnabledForClient.cpm_video_several_pixels_enabled,

                // Разрешено устанавливать TNS ID для медийных баннеров
                isTNSEnabled: {
                    cpm_banner: hasEnabledFeatures('tns_enabled'),
                    cpm_video: hasEnabledFeatures('tns_enabled')
                },

                // Разрешено устанавливать счетчик измерителей для медийных баннеров
                isMeasurersEnabled: withTrueOrUndefined({
                    admetrica: hasEnabledFeatures('admetrica_measurer'),
                    adloox: hasEnabledFeatures('adloox_measurer'),
                    adriver: hasEnabledFeatures('adriver_measurer'),
                    dv: hasEnabledFeatures('dv_measurer'),
                    integral_ad_science: hasEnabledFeatures('integral_ad_science_measurer'),
                    mediascope: hasEnabledFeatures('mediascope_measurer'),
                    moat: hasEnabledFeatures('moat_measurer'),
                    sizmek: hasEnabledFeatures('sizmek_measurer'),
                    weborama: hasEnabledFeatures('weborama_measurer'),
                    omi: hasEnabledFeatures('omi_measurer')
                }),

                // На странице просмотра настроек кампании включены виджеты для суперридеров без роли developer
                campaignSettingsWidgetsForSuperEnabled: hasLoginRights('superreader_control') && !hasLoginRights('is_developer')
            }
        });

        return applyNext();
    }),

    mode('public-params').match(function() {
        return this.name === 'rights';
    })(true));
