BEM.DOM.decl('i-controls-overseer', {
    /**
     * Проверяет соответствие инициатора события фильтру
     * @param {BEM} controlBlock - блок b-control, инициатор события
     * @returns {Boolean}
     * @private
     */
    _isMatchFilter: function(controlBlock) {
        var filter = this.params.of;

        return controlBlock.domElem.is(BEM.blocks[filter.block].buildSelector(filter.elem || ''));
    },

    /**
     * Вызывает событие действия контрола
     * @param {Object} params - объект параметров
     * @param {Array} params.data - данные события
     * @param {Object} params.action - имя события
     * @param {BEM} controlBlock - блок b-control
     * @private
     */
    _triggerEvent: function(params, controlBlock) {
        this.trigger(params.action, {
            data: params.data,
            value: params.value,
            target: controlBlock
        });
    }
}, {
    live: function() {
        this.liveInitOnBlockInsideEvent('actionRequested', 'b-control', function(e, params) {
            !u._.isEmpty(this.params.of) ?
                this._isMatchFilter(e.block) && this._triggerEvent(params, e.block) :
                this._triggerEvent(params, e.block);
        });
    }
});
