BEM.decl('i-crypta-segments-data', {}, {

    requestPromise: null,

    get: function() {
        var self = this;

        this.requestPromise || (this.requestPromise = new Promise(function(resolve, reject) {

            if (self._segments) {
                resolve(u._.cloneDeep(self._segments))
            } else {
                BEM.blocks['i-web-api-request'].crypta
                    .getCryptaSegments(u.consts('ulogin'))
                    .then(function(response) {
                        if (!response.success) {
                            reject(response);
                        } else {
                            self._segments = response.result;
                            resolve(u._.cloneDeep(response.result));
                        }
                    })
                    .catch(function(error) {
                        reject(error);
                    });
            }
        }));

        return this.requestPromise;
    },

    getByType: function(type) {
        var self = this;

        return new Promise(function(resolve, reject) {
            if (self._segmentsByType) {
                resolve(u._.cloneDeep(self._segmentsByType[type]));
            } else {
                self.get()
                    .then(function(segments) {
                        this._segmentsByType = u['crypta'].splitSegmentsByType(segments);
                        resolve(u._.cloneDeep(this._segmentsByType[type] || []));
                    })
                    .catch(function(error) {
                        reject(error);
                    })
            }

        });
    },

    getSegmentsHash: function() {

        return new Promise(function(resolve, reject) {
            if (this._segmentsHash) {
                resolve(u._.cloneDeep(this._segmentsHash));
            } else {
                this.get()
                    .then(function(segments) {
                        this._segmentsHash = segments.reduce(function(hash, segment) {
                            hash[segment.id] = segment;
                            return hash;
                        }, {});
                        resolve(u._.cloneDeep(this._segmentsHash));
                    }.bind(this))
                    .catch(function(error) {
                        reject(error);
                    });
            }
        }.bind(this));
    }

});
