BEM.decl('i-day-budget-dataprovider', {
}, {
    /**
     * Сохраняет данные дневного бюджета кампании
     * @param {Object} requestParams
     * @param {String} requestParams.cid идентификатор кампнании
     * @param {{set: Boolean, sum: String, show_mode: String}} requestParams.dayBudgetData данные дневного бюджета
     * @returns {Promise}
     */
    updateData: function(requestParams) {
        var deferred = $.Deferred(),
            request = this._getRequest();

        request.get({
            cmd: 'ajaxSaveDayBudget',
            ulogin: u.consts('ulogin'),
            csrf_token: u.consts('csrf_token'),
            cid: requestParams.cid,
            json_day_budget: JSON.stringify(requestParams.dayBudgetData)
        },function(data) {
            deferred.resolve(data);
        }, function(data) {
            deferred.reject(data);
        });

        return deferred.promise();
    },

    /**
     * Возвращает экземпляр блока i-request_type_ajax
     * @returns {BEM}
     * @private
     */
    _getRequest: function(params) {
        return BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            callbackCtx: this
        });
    }
});
