BEM.decl('i-direct-request', {
    onSetMod: {
        js: function() {
            this._request = BEM.create('i-request_type_ajax', u._.assign({
                url: '/registered/main.pl',
                dataType: 'json',
                type: 'GET',
                cache: false
            }, this.params || {}));
        }
    },

    /**
     * Совершает запрос
     * @param {Object} data данные запроса
     * @param {Object} [params] дополнительные параметры i-request
     * @returns {Deferred<*, jqXHR>}
     *
     * johnson@todo DIRECT-63057 переделать тех, кто использует этот метод на Promise
     * @deprecated
     */
    getAsJq: function(data, params) {
        var deferred = $.Deferred();

        this._request.get(data, function(res) {
            deferred.resolve(res);
        }, function(err) {
            deferred.reject(err);
        }, params || {});

        return deferred.promise();
    },

    /**
     * Совершает запрос
     *
     * @param {Object} data данные, передаваемые с запросом
     * @param {Object} [params] параметры запроса i-request. заменяют дефолтные
     * @returns {Promise<*>}
     */
    get: function(data, params) {
        return new Promise(function(resolve, reject) {
            this.getAsJq(data, params)
                .fail(reject)
                .done(resolve);
        }.bind(this));
    }
});
