describe('i-error-groups-summary', function() {
    var genericError = [{ "text" : "Неверные входные данные" }],
        groupsData = [
            {
                'adgroup_id': '1420373240',
                'group_name': '',
                'banners': [{ 'bid': 2007268510 }]
            },
            {
                'adgroup_id': '1420385629',
                'group_name': '',
                'banners': [{ 'bid': 2007283998 }]
            },
            {
                'adgroup_id': '1420385630',
                'group_name': '',
                'banners': [{ 'bid':2007283999 }]
            },
            {
                'adgroup_id': '1420385631',
                'group_name': '',
                'banners': [{ 'bid':2007284000 }]
            }
        ],
        errorsData = {
            'groups': {
                "generic_errors" : genericError,
                'array_errors': [
                    {
                        'object_errors': {
                            'group_name': [{ 'text': 'Поле обязательно для заполнения' }]
                        }
                    },
                    {
                        'object_errors': {
                            'dynamic_conditions': {
                                "array_errors" : [
                                    null,
                                    [
                                        {
                                            "description" : "Фильтры в группе объявлений должны быть уникальны",
                                            "suffix" : "",
                                            "text" : "Неконсистентное состояние объекта",
                                            "name" : "InconsistentState",
                                            "code" : "6000",
                                            "type" : "error"
                                        }
                                    ]
                                ]
                            }
                        }
                    },
                    {
                        'object_errors': {
                            'banners': {
                                'array_errors': [
                                    {
                                        'object_errors': {
                                            'body': [{ 'text': 'Поле обязательно для заполнения' }]
                                        }
                                    },
                                    {
                                        "generic_errors" : [{
                                            "type" : "error",
                                            "text" : "Язык не соответствует геотаргетингу",
                                            "code" : "6101",
                                            "name" : "BadLang",
                                            "description" : "Текст объявления написан на украинском языке и не соответствует установленному региону показа. Возможен таргетинг только на Украину.",
                                            "suffix" : ""
                                        }]
                                    }
                                ]
                            }
                        }
                    },
                    { "generic_errors" : [{ "text" : "Ошибка: условия нацеливания не найдены." }] }
                ]
            }
        };

    it('Должен формировать объект с ключами generic, title, groups, banners', function() {
        var res = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupsData, errorsData);

        expect(res).to.have.all.keys(['generic', 'title', 'groups', 'banners']);
    });

    it('Должен включать в generic общие ошибки про группы', function() {
        var res = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupsData, errorsData);

        expect(res.generic).to.eql(genericError);
    });

    it('Должен включать в title группы с ошибками в заголовке', function() {
        var res = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupsData, errorsData);

        expect(res.title).to.eql([groupsData[0]]);
    });

    it('Должен включать в groups группы с любыми ошибками, кроме ошибок в заголовке и в баннерах (в том числе с generic_errors)', function() {
        var res = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupsData, errorsData);

        expect(res.groups).to.eql([groupsData[1], groupsData[3]]);
    });

    it('Должен включать в banners пары группа/объявление с ошибками в объявлениях', function() {
        var res = BEM.blocks['i-error-groups-summary'].summarizeErrors(groupsData, errorsData);

        expect(res.banners).to.eql([
            {
                group: groupsData[2],
                banner: groupsData[2].banners[0]
            },
            {
                group: groupsData[2],
                banner: groupsData[2].banners[1]
            }
        ]);
    });
});
