BEM.decl('i-event-bus', {}, {

    _busesHash: {},

    /**
     * Возвращает флаг наличия i-event-bus в opener странице
     * Если opener отсутствует, то вернёт false
     * @see DIRECT-48085
     * @see DIRECT-48042
     * @see DIRECT-48031
     * @see DIRECTSUP-22783
     * @param {Window} target
     * @returns {Boolean}
     * @private
     */
    _hasTargetEventBus: function(target) {
        try {
            // opener может быть доступен для чтения его свойств, но блока i-event-bus там может не оказаться
            return !!target.BEM.blocks['i-event-bus'];
        } catch (ex) {
            return false;
        }
    },

    /**
     * Возвращает шину событий
     * "Взбирается" до верхнего окна при поиске шины во фрэймах и нативных попапах
     * @param {String} name имя шины
     * @return {BEM}
     */
    getEventBus: function(name) {
        // если имеется читабельный opener с i-event-bus, то в берём BEM из него
        // иначе BEM топового фрэйма, если в нём есть i-event-bus, а если его нет, то BEM текущей страницы
        var BEM = this._hasTargetEventBus(window.opener) ?
                window.opener.BEM :
                this._hasTargetEventBus(window.top) ?
                    window.top.BEM :
                    window.BEM,
            busesHash = BEM.blocks['i-event-bus']._busesHash;

        return busesHash[name] || (busesHash[name] = BEM.create('i-event-bus'));
    }

});
