(function() {
    var dictionary = {
        1201: iget2('i-feeds-errors-dictionary', 'nevozmozhno-skachat-fid', 'Невозможно скачать фид'),
        1202: iget2('i-feeds-errors-dictionary', 'oshibka-specifikacii-xml', 'Ошибка спецификации XML'),
        1203: iget2(
            'i-feeds-errors-dictionary',
            'fid-ne-soderzhit-obyazatelnyh',
            'Фид не содержит обязательных параметров <model> или <name>'
        ),
        1204: iget2('i-feeds-errors-dictionary', 'nevozmozhno-obrabotat-fid', 'Невозможно обработать фид'),
        1205: iget2('i-feeds-errors-dictionary', 'fid-ne-soderzhit-tovarnyh', 'Фид не содержит товарных предложений'),
        1206: iget2('i-feeds-errors-dictionary', 'fid-ne-soderzhit-spisok', 'Фид не содержит список категорий'),
        1207: iget2('i-feeds-errors-dictionary', 'v-fide-otsutstvuyut-ssylki', 'В фиде отсутствуют ссылки на товарные предложения'),
        1211: iget2('i-feeds-errors-dictionary', 'pustoy-fayl', 'Пустой файл'),
        1212: iget2('i-feeds-errors-dictionary', 'nevozmozhno-opredelit-format-fida', 'Невозможно определить формат фида'),
        1213: iget2('i-feeds-errors-dictionary', 'nevozmozhno-opredelit-tip-dannyx-v-fide', 'Невозможно определить тип данных в фиде'),
        1217: iget2('i-feeds-errors-dictionary', 'oshibka-parsinga-fida', 'Ошибка парсинга фида'),
        1266: iget2(
            'i-feeds-errors-dictionary',
            'razmer-fayla-prevyshaet-maksimalno',
            'Размер файла превышает максимально допустимый размер фида'
        ),
        1812: iget2('i-feeds-errors-dictionary', 'fid-nedostupen-dlya-obrabotki', 'Фид недоступен для обработки'),
        1220: iget2('i-feeds-errors-dictionary', 'fid-ne-sootvetstvuet-ukazannomu', 'Фид не соответствует указанному типу бизнеса'),
        1290: iget2('i-feeds-errors-dictionary', 'id-kategoriy-dolzhny-byt', 'ID категорий должны быть целыми положительными числами')
    };

    u.register({
        'i-feeds-errors-dictionary': {
            /**
             *
             * @param {Object} errorData
             * @param {String} errorData.code код ошибки
             * @param {String} errorData.message текст ошибки пришедший с сервера (на клиенте хранятся более подробные данные)
             * @returns {String}
             */
            getErrorText: function(errorData) {
                return u.escapeHTML(dictionary[errorData.code] || iget2('i-feeds-errors-dictionary', 'oshibka-zagruzki', 'Ошибка загрузки'));
            }
        }
    });
})();
