BEM.DOM.decl('i-filter-conditions-group', {
    onSetMod: {
        js: function() {
            this._filterModel = BEM.MODEL.getOne(this.params.modelParams);

            this._initEvents();
        }
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._subscriptionManager = BEM.create('i-subscription-manager');

        this._initCommonEvents();
    },

    _initCommonEvents: function() {
        throw new Error('Must be implemented in subclasses');
    },

    /**
     * Удаляет блок и подписки i-subscription-manager
     * @override
     */
    destruct: function() {
        //у дочерних блоков _subscriptionManager не является обязательным элементом
        this._subscriptionManager && this._subscriptionManager.dispose();
        this.__base();
    }
});
