(function() {
    u.register({
        'i-filter-edit__validator': {
            /**
             * Валидирует значение value по правилу rule
             * @param {Object} rule
             * @param {String} rule.name
             * @param {String} rule.error
             * @param {*} rule.parameters
             * @param {*} value
             * @returns {boolean}
             */
            validate: function(rule, value) {
                var paramRegexp;

                switch (rule.name) {
                    case 'maxValue':
                        return (+value <= rule.parameters);
                    case 'minValue':
                        return (+value >= rule.parameters);
                    case 'minLength':
                        return (value + '').length >= rule.parameters;
                    case 'maxLength':
                        return (value + '').length <= rule.parameters;
                    case 'patternMatch':
                        paramRegexp = new RegExp(rule.parameters);

                        return checkMixedTypeValue(value, function(value) {
                            return (value + '').match(paramRegexp);
                        });
                    case 'boundaryMinValue':
                        return (+value.min >= rule.parameters && +value.max >= rule.parameters);
                    case 'boundaryMaxValue':
                        return (+value.max <= rule.parameters && +value.min <= rule.parameters);
                    case 'boundaryPatternMatch':
                        paramRegexp = new RegExp(rule.parameters);

                        return (value.min + '').match(paramRegexp) && (value.max + '').match(paramRegexp);
                    case 'leftLessRight':
                        return +value.min < +value.max;
                    case 'itemsCountMax':
                        return value.length <= rule.parameters;
                    case 'itemsCountMin':
                        return value.length >= rule.parameters;
                    case 'correctUrl':
                        //url без протокола считаем некорректным
                        return u.validateHref(value) && u.getUrlProtocol(value);
                    case 'containsDisallowedLetters':
                        return checkMixedTypeValue(value, checkDisallowedLetters);
                    default:
                        return true;
                }
            }
        }
    });

    /**
     * Если value не объект - применяет к value checkFunc
     * Если value - объект, применяет value к каждому полю value
     * @param {*} value
     * @param {Function} checkFunc
     * @returns {*}
     */
    function checkMixedTypeValue(value, checkFunc) {
        if (u._.isObject(value)) {
            return Object.keys(value).every(function(key) {
                return checkFunc(value[key]);
            });
        } else {
            return checkFunc(value);
        }
    }

    function checkDisallowedLetters(value) {
        var allowsLettersRegexp =
            new RegExp('^[' + u.consts('ALLOW_LETTERS') + '!?\\(\\)%\$€;:\\/&\'*_=#№«»/\u00A0–—−]+?');

        return (value + '').match(allowsLettersRegexp);
    }
})();
