BEM.DOM.decl({ block: 'i-filter-edit', baseBlock: 'i-glue', implements: 'i-modal-popup-inner-block-interface' }, {
    onSetMod: {
        js: function() {
            //убираем инициализацию модели до после загрузки фильтра
        }
    },

    /**
     * Текущий тип фильтра, объявляется в основном блоке
     */
    _currentFilterType: null,

    /**
     * Инициализирует блок
     */
    initialize: function() {
        var deferred = $.Deferred();

        BEM.blocks['i-filter-edit'].loadConfig(this._currentFilterType)
            .then(this._onConfigLoaded.bind(this))
            .then(function() { deferred.resolve(this); }.bind(this));

        return deferred.promise();
    },

    /**
     * Реакция на событие "конфиг для фильтров загрузился"
     * @private
     */
    _onConfigLoaded: function() {
        //инициализируем и проклеиваем модель
        this.glue();

        u.graspSelf.call(this, {
            _list: 'filter-conditions-list inside'
        });

        this._initEvents();
    },

    /**
     * Возвращает менеджер подписок
     * @returns {Object}
     * @private
     */
    _getSubscriptionManager: function() {
        return this._subscriptionManager || (this._subscriptionManager = BEM.create('i-subscription-manager'));
    },

    /**
     * Выполняет подписку на события через i-subscription-manager
     * @private
     */
    _initEvents: function() {
        this._getSubscriptionManager().wrap(this._getSaveBtnBlock())
            .on('click', this._onSaveBtnClick, this);

        this._getSubscriptionManager().wrap(this._getCancelBtnBlock())
            .on('click', function() {
                this.trigger('filter:edit:canceled');
            }, this);
    },

    /**
     * Возвращает блок кнопки "Сохранить"
     * @returns {BEM}
     * @private
     */
    _getSaveBtnBlock: function() {
        return this._saveBtn || (this._saveBtn = this.findBlockOn('save', 'button'));
    },

    /**
     * Возвращает блок кнопки "Отмена"
     * @returns {BEM}
     * @private
     */
    _getCancelBtnBlock: function() {
        return this._cancelBtn || (this._cancelBtn = this.findBlockOn('cancel', 'button'));
    },

    /**
     * Обработчик события "клик на кнопку Сохранить"
     * @private
     */
    _onSaveBtnClick: function() {
        throw new Error('must be implemented in subclass');
    },

    /**
     * Удаляет сообщения об ошибках
     * @private
     */
    _clearErrors: function() {
        this._getErrorPresenter().clearErrors('feed-filter-edit');

        return this;
    },

    /**
     * Были ли изменения
     * @returns {$.Deferred<Boolean>}
     */
    isChanged: function() {
        throw new Error('must be implemented in subclass');
    },

    /**
     * Показывает ошибки в форме
     * @param {Object} errors
     * @protected
     */
    _showErrors: function(errors) {
        this._clearErrors();

        this._getErrorPresenter().showErrors(u['error'].flattenClient(errors, 'feed-filter-edit'));
    },

    /**
     * Возвращает блок распределения ошибок
     * @returns {BEM.DOM}
     * @protected
     */
    _getErrorPresenter: function() {
        return this._errorPresenter || (this._errorPresenter = this.findBlockOn('b-error-presenter'));
    },

    /**
     * Удаляет блок, модель и подписки i-subscription-manager
     * @override
     * @fires b-feed-filter-edit#destruct
     */
    destruct: function() {
        this._getSubscriptionManager().dispose();

        this.__base();

        this.model && this.model.destruct();
    }
}, {
    /**
     * Загружаем с сервера конфиг, которым будем пользоваться при построении условий фильтров
     * @returns {Promise}
     */
    loadConfig: function(filterType) {
        //пока тип фильтра может быть только 'performance'
        //в ближайшем будущем добавится 'dynamic'
        filterType = filterType || 'performance';

        var dfd = $.Deferred();

        if (this._schema) {
            dfd.resolve();
        } else {
            dfd.then(function(config) {
                u['i-filter-edit'].setSchema(config.schema);
            }.bind(this));

            BEM.create('i-request_type_ajax', {
                type: 'post',
                url: '/registered/main.pl',
                dataType: 'json',
                callbackCtx: this
            }).get(
                {
                    cmd: 'ajaxGetFilterSchema',
                    filter_type: filterType
                },
                function(result) { dfd.resolve(result) },
                function(err) { dfd.reject(err) }
            );
        }

        return dfd.promise();
    }
});
