describe('i-filter-edit', function() {
    describe('Метод u[\'i-filter-edit\'].isValueNotNeededToChange()', function() {
        [
            { newCond: { field: 'vendor', relation: 'ilike' }, prevCond: { field: 'category_id', relation: 'not ilike' }, result: false },
            { newCond: { field: 'vendor', relation: 'ilike' }, prevCond: { field: 'category_id', relation: 'ilike' }, result: false },
            { newCond: { field: 'vendor', relation: 'ilike' }, prevCond: { field: 'vendor', relation: 'not ilike' }, result: true },
            { newCond: { field: 'vendor', relation: 'not ilike' }, prevCond: { field: 'vendor', relation: 'ilike' }, result: true },
            { newCond: { field: 'category_id', relation: '<' }, prevCond: { field: 'category_id', relation: '>' }, result: true },
            { newCond: { field: 'category_id', relation: '<' }, prevCond: { field: 'category_id', relation: '==' }, result: false },
            { newCond: { field: 'category_id', relation: '<' }, prevCond: { field: 'category_id', relation: '<->' }, result: false },
            { newCond: { field: 'category_id', relation: '>' }, prevCond: { field: 'category_id', relation: '<' }, result: true },
            { newCond: { field: 'category_id', relation: '>' }, prevCond: { field: 'category_id', relation: '==' }, result: false },
            { newCond: { field: 'category_id', relation: '>' }, prevCond: { field: 'category_id', relation: '<->' }, result: false },
            { newCond: { field: 'category_id', relation: '==' }, prevCond: { field: 'category_id', relation: '>' }, result: true },
            { newCond: { field: 'category_id', relation: '==' }, prevCond: { field: 'category_id', relation: '<' }, result: true },
            { newCond: { field: 'category_id', relation: '<->' }, prevCond: { field: 'category_id', relation: '>' }, result: false },
            { newCond: { field: 'category_id', relation: '==' }, prevCond: { field: 'category_id', relation: '<->' }, result: false }
        ].forEach(function(testData) {
            it('Метод u[\'i-filter-edit\'].isValueNotNeededToChange(' + JSON.stringify(testData.newCond)+ ', ' + JSON.stringify(testData.prevCond) + ') = ' + testData.result, function() {
                expect(u['i-filter-edit'].isValueNotNeededToChange(testData.newCond, testData.prevCond)).to.be.equal(testData.result);
            });
        })
    })
});
