BEM.DOM.decl('i-foreign-iframe', {
    onSetMod: {
        js: function() {
            this
                .bindTo('load', function(e) {
                    this.trigger(e.type);
                })
                .bindToWin('message', function(e) {
                    // Если на странице создано 2 блока i-foreign-iframe, и в каком-то из них iframe присылает
                    // postMessage, то без условия тригерят оба. С условием - только  нужный
                    if (this.domElem[0].contentWindow == e.originalEvent.source) {
                        this.trigger('message', e.originalEvent);
                    }
                });
        }
    },

    /**
     * Проксирование postMessage
     * @param {String} data JSON-сериализованный объект с данными для отправки
     * @param {String} targetOrigin url источника, окнам которого разрешено принимать сообщение. При указании '*' ограничений нет.
     */
    postMessage: function(data, targetOrigin) {
        // collapsus@ почему-то this.domElem[0].contentWindow.postMessage.apply(null, arguments) работает некорректно
        this.domElem[0].contentWindow.postMessage(data, targetOrigin);
    }
});
