BEM.DOM.decl({ block: 'i-form', modName: 'submit', modVal: 'bem-event' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // извлекаем ссылку на DOM узел для работы с его API
            this._form = this.domElem.get(0);

            if (this.domElem.prop('tagName').toUpperCase() !== 'FORM') {
                throw new Error('i-form_submit-bem-event must have a form DOM node');
            }

            // подписываемся на события для из перехвата
            // и инициирования одноименных событий от лица блока
            this.bindTo('reset submit', function(e) {
                e.preventDefault();

                this.trigger(e.type);
            });
        }
    },

    /**
     * Выполняет reset у DOM-элемента формы
     */
    reset: function() {
        this._form.reset();
    },

    /**
     * Выполняет submit у DOM-элемента формы
     */
    submit: function() {
        // используется submit метод DOM элемента, не jQuery,
        // так как последний триггерит событие submit и
        // кидается исключение Maximum call stack size exceeded
        this._form.submit();
    }

});
