(function() {

    BEM.DOM.decl('i-form', {

        _getSerializedArray: function() {
            return this.domElem.find(':input').serializeArray();
        },

        /**
         * Возвращает объект с ключами - именами, а значениями - значениями контролов формы
         * @returns {Object}
         */
        serialize: function() {
            var result = {},
                array = this._getSerializedArray();

            array.forEach(function(item) {
                if (result[item.name] !== undefined) {
                    if (!$.isArray(result[item.name])) {
                        result[item.name] = [result[item.name]];
                    }
                    result[item.name].push(item.value || '');
                } else {
                    result[item.name] = item.value || '';
                }
            });

            return result;
        }

    }, {

        submit: function(obj) {
            var params = obj.params || {},
                form = $('<form/>', {
                    action: obj.action || location.href.replace(/\?.*/, ''),
                    method: obj.method || 'post',
                    style: 'display: none;'
                }),
                paramValue;

            for (var paramName in params) {
                if (params.hasOwnProperty(paramName)) {
                    paramValue = params[paramName];

                    if (Array.isArray(paramValue)) {
                        /*jshint loopfunc: true */
                        paramValue.forEach(function(value) {
                            form.append($('<input/>', {
                                name: paramName,
                                value: value
                            }));
                        });
                    } else {
                        form.append($('<input/>', {
                            name: paramName,
                            value: paramValue
                        }));
                    }
                }
            }

            form
                .appendTo(BEM.blocks['b-page'].getInstance().domElem)
                .submit();
        }

    });

})();
