(function() {

    var ready = false;

    BEM.DOM.decl('i-get-export-data', {}, {
        /**
         * Вызывает функцию обратного вызова с актуальными параметрами
         * Функция создана по результатам ревью для облегчения будущего рефакторинга
         * inboxCounters - глобальная переменная
         *
         * @param {Function} func
         * @param {Object} ctx
         * @private
         */
        _callbackFuncCall: function(func, ctx) {
            func.call(ctx, window.inboxCounters || {});
        },

        /**
         * Статический метод получения данных с export.yandex.ru.
         * Вызывается по мере необходимости. Запрос делается только при первом вызове.
         * Делаем полностью динамическую вставку, так как изменение src для загрузки данных
         * не кроссбраузерно + необходимо куда-то вставлять тег скрипт, что не всегда удобно
         *
         * @param {Function} callback Функция принимающая в параметре данные с экспорта
         * @param {Object} [ctx] Контекст вызова callback
         */
        getData: function(callback, ctx) {
            var _this = this,
                script;

            if (ready) {
                this._callbackFuncCall(callback, ctx);
            } else {
                script = document.createElement('script');

                script.charset = 'windows-1251';  //пока необходимый атрибут
                script.src = '//export.yandex.ru/counters-js.xml?services=45';

                script.onload = script.onreadystatechange = function() {
                    if (!this.readyState || this.readyState == 'loaded' || this.readyState == 'complete') {
                        ready = true;

                        _this._callbackFuncCall(callback, ctx);

                        //снимаем обработчики и удаляем тег
                        script.onload = script.onreadystatechange = null;
                        document.body.removeChild(script);
                    }
                };

                document.body.appendChild(script);
            }
        }
    });
})();
