function OpenWindow(url, width, height, name, focus) {
    var windowsSize = (width && height) ? ('width=' + width + ',height=' + height) : '',
        wnd = window.open(url, name, windowsSize + ',status=yes,menubar=no,resizable=yes,scrollbars=1');

    if (focus) wnd.focus();

    if (window.event)
        window.event.returnValue = false;

    return false;
}

BEM.blocks['i-global'].on('init', function(e) {
    // в DIRECT-44235, очень не очевидно ломалась установка csrf_token-а
    // т. к. раньше биндились на BEM.on('init', ...), а после изменения deps-ов i-global-а
    // порядок блоков без DOM-представления изменился, и в ajaxSetup записался undefined вместо токена,
    // из-за того что i-global не был проинициализирован на момент срабатывания бинда
    // теперь перед установкой csrf_token ждём инициализации i-global-а, чтобы параметры не были пустыми
    if (window.$) {
        $.ajaxSetup({
            data: { csrf_token: u.consts('csrf_token') },
        });
        $.ajaxPrefilter(function(options, originalOptions) {
            var headers = options.headers || {},
                pageParams;

            if (u.isPassportSupportPinCodeUrl(options.url)) {
                options.data = $.param(originalOptions.data);
            }

            if (!options.crossDomain) {
                pageParams = ['reqid', 'cmd'].filter(function(pageParam) {
                    return u.consts(pageParam);
                }).map(function(pageParam) {
                    return [pageParam, u.consts(pageParam)].join(':');
                }).join(',');

                headers['X-Req-Info'] = pageParams;
            }

            options.headers = headers;
        });
    }

    u.currencies.init({
        currencies: u.consts('currencies'),
        pseudoCurrency: u.consts('pseudo_currency'),
        currencyTextsDescription: u.consts('currency_texts_description'),
        fixedCurrencyRates: u.consts('fixed_currency_rates'),
        locationNameI18N: iget2
    });
});
